/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.monitor.client.java.thread;

import com.alibaba.fastjson.JSON;
import com.github.houbb.checksum.core.util.ChecksumHelper;
import com.github.houbb.common.api.api.dto.req.CommonApiRequest;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.hibernator.valid.util.ValidHelper;
import com.github.houbb.http.client.util.OkHttpClientHelper;
import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.core.LogFactory;
import com.github.houbb.monitor.client.api.request.MonitorLogRequest;
import com.github.houbb.monitor.client.api.request.component.MonitorLogItem;
import com.github.houbb.monitor.client.api.response.MonitorLogResponse;
import com.github.houbb.monitor.client.java.thread.MonitorServerPushThreadConfig;
import java.util.ArrayList;
import java.util.Queue;

public class MonitorServerPushThread
extends Thread {
    private static final Log LOG = LogFactory.getLog(MonitorServerPushThread.class);
    private final MonitorServerPushThreadConfig config;

    public MonitorServerPushThread(MonitorServerPushThreadConfig config) {
        this.config = config;
    }

    @Override
    public void run() {
        try {
            Queue<MonitorLogItem> queue = this.config.getQueue();
            if (queue.isEmpty()) {
                LOG.warn("\u961f\u5217\u4e3a\u7a7a\uff0c\u5ffd\u7565\u5904\u7406");
                return;
            }
            int maxLimit = this.config.getMaxBatchSize();
            ArrayList<MonitorLogItem> list = new ArrayList<MonitorLogItem>(maxLimit);
            while (!queue.isEmpty() && list.size() < maxLimit) {
                MonitorLogItem item = queue.poll();
                list.add(item);
            }
            if (CollectionUtil.isEmpty(list)) {
                LOG.warn("\u961f\u5217\u4e3a\u7a7a\uff0c\u5ffd\u7565\u5904\u7406\u3002");
                return;
            }
            MonitorLogRequest request = new MonitorLogRequest();
            request.setItemList(list);
            this.fillAndCallServer((CommonApiRequest)request, "api/monitor/log/add", MonitorLogResponse.class);
        }
        catch (Exception e) {
            LOG.error("\u4efb\u52a1\u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
    }

    private <R> R fillAndCallServer(CommonApiRequest request, String urlSuffix, Class<R> responseClass) {
        try {
            String traceId = this.config.getTraceIdGenerator().id();
            request.setTraceId(traceId);
            request.setRequestTime(Long.valueOf(System.currentTimeMillis()));
            request.setSystemId(this.config.getSystemId());
            request.setEnvId(this.config.getEnvId());
            ChecksumHelper.fill((Object)request, (String)this.config.getSaltKey());
            ValidHelper.failFast((Object)request);
            String url = this.config.getServerAddress() + urlSuffix;
            String json = JSON.toJSONString((Object)request);
            LOG.info("\u5f00\u59cb\u8bf7\u6c42\u670d\u52a1\u7aefurl {}, json {}", new Object[]{url, json});
            String resultJson = OkHttpClientHelper.postJson((String)url, (String)json);
            LOG.info("\u5b8c\u6210\u8bf7\u6c42\u670d\u52a1\u7aef {}", new Object[]{resultJson});
            return (R)JSON.parseObject((String)resultJson, responseClass);
        }
        catch (Exception e) {
            LOG.error("\u8bf7\u6c42\u670d\u52a1\u7aef\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }
}

