package com.github.houbb.sql.budiler.api;

/**
 * 查询构建
 *
 * CRUD 优先，DDL 基本不会经常出现。
 *
 * where 独立出来，作为核心。
 *
 * @since 0.1.0
 */
public interface ISqlSelectBuilder extends ISqlBuilder {

    ISqlSelectBuilder select(String column);

    ISqlSelectBuilder from(String tableName);

    ISqlSelectBuilder where(String condition);

    ISqlSelectBuilder groupBy(String condition);

    ISqlSelectBuilder having(String condition);

    ISqlSelectBuilder orderBy(String condition);

    ISqlSelectBuilder limit(int offset, int value);

    ISqlSelectBuilder limit(int value);


}
