/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.io.IOException;
import java.util.Iterator;
import java.util.TreeSet;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.io.MatrixInfo;
import no.uib.cipr.matrix.io.MatrixSize;
import no.uib.cipr.matrix.io.MatrixVectorReader;
import no.uib.cipr.matrix.sparse.Arrays;

public class CompDiagMatrix
extends AbstractMatrix {
    double[][] diag;
    int[] ind;

    public CompDiagMatrix(MatrixVectorReader r) throws IOException {
        block14: {
            int i;
            double[] entry;
            int[] column;
            int[] row;
            MatrixSize size;
            MatrixInfo info;
            block13: {
                super(0, 0);
                info = null;
                info = r.hasInfo() ? r.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                size = r.readMatrixSize(info);
                this.numRows = size.numRows();
                this.numColumns = size.numColumns();
                if (info.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (info.isDense()) {
                    throw new UnsupportedOperationException("Dense matrices are not supported");
                }
                if (info.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                row = new int[size.numEntries()];
                column = new int[size.numEntries()];
                entry = new double[size.numEntries()];
                r.readCoordinate(row, column, entry);
                r.add(-1, row);
                r.add(-1, column);
                TreeSet<Integer> diags = new TreeSet<Integer>();
                int i2 = 0;
                while (i2 < size.numEntries()) {
                    diags.add(CompDiagMatrix.getDiagonal(row[i2], column[i2]));
                    ++i2;
                }
                if (info.isSymmetric() || info.isSkewSymmetric()) {
                    i2 = 0;
                    while (i2 < size.numEntries()) {
                        if (row[i2] != column[i2]) {
                            diags.add(CompDiagMatrix.getDiagonal(column[i2], row[i2]));
                        }
                        ++i2;
                    }
                }
                int[] ind = new int[diags.size()];
                Integer[] ints = new Integer[diags.size()];
                diags.toArray(ints);
                int i3 = 0;
                while (i3 < diags.size()) {
                    ind[i3] = ints[i3];
                    ++i3;
                }
                this.construct(ind);
                i = 0;
                while (i < size.numEntries()) {
                    this.set(row[i], column[i], entry[i]);
                    ++i;
                }
                if (!info.isSymmetric()) break block13;
                i = 0;
                while (i < size.numEntries()) {
                    if (row[i] != column[i]) {
                        this.set(column[i], row[i], entry[i]);
                    }
                    ++i;
                }
                break block14;
            }
            if (!info.isSkewSymmetric()) break block14;
            i = 0;
            while (i < size.numEntries()) {
                if (row[i] != column[i]) {
                    this.set(column[i], row[i], -entry[i]);
                }
                ++i;
            }
        }
    }

    public CompDiagMatrix(int numRows, int numColumns, int[] diagonal) {
        super(numRows, numColumns);
        this.construct(diagonal);
    }

    private void construct(int[] diagonal) {
        this.diag = new double[diagonal.length][];
        this.ind = new int[diagonal.length];
        int[] sortedDiagonal = new int[diagonal.length];
        System.arraycopy(diagonal, 0, sortedDiagonal, 0, diagonal.length);
        java.util.Arrays.sort(sortedDiagonal);
        int i = 0;
        while (i < diagonal.length) {
            this.ind[i] = sortedDiagonal[i];
            this.diag[i] = new double[this.getDiagSize(sortedDiagonal[i])];
            ++i;
        }
    }

    public CompDiagMatrix(int numRows, int numColumns) {
        this(numRows, numColumns, new int[0]);
    }

    public CompDiagMatrix(Matrix A, int[] diagonal, boolean deep) {
        super(A);
        if (deep) {
            this.construct(diagonal);
            this.set(A);
        } else {
            CompDiagMatrix Ac = (CompDiagMatrix)A;
            this.diag = Ac.getDiagonals();
            this.ind = Ac.getIndex();
        }
    }

    public CompDiagMatrix(Matrix A, int[] diagonal) {
        this(A, diagonal, true);
    }

    public CompDiagMatrix(Matrix A, boolean deep) {
        this(A, new int[0], deep);
    }

    public CompDiagMatrix(Matrix A) {
        this(A, new int[0], true);
    }

    public double[][] getDiagonals() {
        return this.diag;
    }

    public int[] getIndex() {
        return this.ind;
    }

    @Override
    public void add(int row, int column, double value) {
        this.check(row, column);
        int diagonal = this.getCompDiagIndex(row, column);
        double[] dArray = this.diag[diagonal];
        int n = CompDiagMatrix.getOnDiagIndex(row, column);
        dArray[n] = dArray[n] + value;
    }

    @Override
    public double get(int row, int column) {
        this.check(row, column);
        int diagonal = java.util.Arrays.binarySearch(this.ind, CompDiagMatrix.getDiagonal(row, column));
        if (diagonal >= 0) {
            return this.diag[diagonal][CompDiagMatrix.getOnDiagIndex(row, column)];
        }
        return 0.0;
    }

    @Override
    public void set(int row, int column, double value) {
        this.check(row, column);
        int diagonal = this.getCompDiagIndex(row, column);
        this.diag[diagonal][CompDiagMatrix.getOnDiagIndex((int)row, (int)column)] = value;
    }

    private static int getDiagonal(int row, int column) {
        return column - row;
    }

    private static int getOnDiagIndex(int row, int column) {
        return row > column ? column : row;
    }

    private int getCompDiagIndex(int row, int column) {
        int diagonal = CompDiagMatrix.getDiagonal(row, column);
        int index = Arrays.binarySearchGreater(this.ind, diagonal);
        if (index < this.ind.length && this.ind[index] == diagonal) {
            return index;
        }
        int size = this.getDiagSize(diagonal);
        double[] newDiag = new double[size];
        double[][] newDiagArray = new double[this.diag.length + 1][];
        int[] newInd = new int[this.ind.length + 1];
        System.arraycopy(this.ind, 0, newInd, 0, index);
        System.arraycopy(this.ind, index, newInd, index + 1, this.ind.length - index);
        int i = 0;
        while (i < index) {
            newDiagArray[i] = this.diag[i];
            ++i;
        }
        i = index;
        while (i < this.diag.length) {
            newDiagArray[i + 1] = this.diag[i];
            ++i;
        }
        newInd[index] = diagonal;
        newDiagArray[index] = newDiag;
        this.ind = newInd;
        this.diag = newDiagArray;
        return index;
    }

    private int getDiagSize(int diagonal) {
        if (diagonal < 0) {
            return Math.min(this.numRows + diagonal, this.numColumns);
        }
        return Math.min(this.numRows, this.numColumns - diagonal);
    }

    @Override
    public Matrix copy() {
        return new CompDiagMatrix((Matrix)this, this.ind);
    }

    @Override
    public Matrix zero() {
        int i = 0;
        while (i < this.diag.length) {
            java.util.Arrays.fill(this.diag[i], 0.0);
            ++i;
        }
        return this;
    }

    @Override
    public Vector mult(Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.mult(x, y);
        }
        this.checkMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        y.zero();
        int i = 0;
        while (i < this.ind.length) {
            int row = this.ind[i] < 0 ? -this.ind[i] : 0;
            int column = this.ind[i] > 0 ? this.ind[i] : 0;
            double[] locDiag = this.diag[i];
            int j = 0;
            while (j < locDiag.length) {
                int n = row++;
                yd[n] = yd[n] + locDiag[j] * xd[column];
                ++j;
                ++column;
            }
            ++i;
        }
        return y;
    }

    @Override
    public Vector multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.multAdd(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        int i = 0;
        while (i < this.ind.length) {
            int row = this.ind[i] < 0 ? -this.ind[i] : 0;
            int column = this.ind[i] > 0 ? this.ind[i] : 0;
            double[] locDiag = this.diag[i];
            int j = 0;
            while (j < locDiag.length) {
                int n = row++;
                yd[n] = yd[n] + alpha * locDiag[j] * xd[column];
                ++j;
                ++column;
            }
            ++i;
        }
        return y;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.transMultAdd(alpha, x, y);
        }
        this.checkTransMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        int i = 0;
        while (i < this.ind.length) {
            int row = this.ind[i] < 0 ? -this.ind[i] : 0;
            int column = this.ind[i] > 0 ? this.ind[i] : 0;
            double[] locDiag = this.diag[i];
            int j = 0;
            while (j < locDiag.length) {
                int n = column++;
                yd[n] = yd[n] + alpha * locDiag[j] * xd[row];
                ++j;
                ++row;
            }
            ++i;
        }
        return y;
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new CompDiagMatrixIterator();
    }

    private final class CompDiagMatrixEntry
    implements MatrixEntry {
        private int diagonal;
        private int index;

        private CompDiagMatrixEntry() {
        }

        public void update(int diagonal, int index) {
            this.diagonal = diagonal;
            this.index = index;
        }

        @Override
        public int row() {
            return this.index + (CompDiagMatrix.this.ind[this.diagonal] < 0 ? -CompDiagMatrix.this.ind[this.diagonal] : 0);
        }

        @Override
        public int column() {
            return this.index + (CompDiagMatrix.this.ind[this.diagonal] > 0 ? CompDiagMatrix.this.ind[this.diagonal] : 0);
        }

        @Override
        public double get() {
            return CompDiagMatrix.this.diag[this.diagonal][this.index];
        }

        @Override
        public void set(double value) {
            CompDiagMatrix.this.diag[this.diagonal][this.index] = value;
        }
    }

    private final class CompDiagMatrixIterator
    implements Iterator<MatrixEntry> {
        private int diagonal;
        private int index;
        private CompDiagMatrixEntry entry;

        private CompDiagMatrixIterator() {
            this.entry = new CompDiagMatrixEntry();
        }

        @Override
        public boolean hasNext() {
            return this.diagonal < CompDiagMatrix.this.diag.length;
        }

        @Override
        public MatrixEntry next() {
            this.entry.update(this.diagonal, this.index);
            if (this.index < CompDiagMatrix.this.diag[this.diagonal].length - 1) {
                ++this.index;
            } else {
                ++this.diagonal;
                this.index = 0;
            }
            return this.entry;
        }

        @Override
        public void remove() {
            this.entry.set(0.0);
        }
    }
}

