/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.err.Xerbla;
import org.netlib.lapack.Dlarf;
import org.netlib.lapack.Dlarfg;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public final class Dgehd2 {
    public static void dgehd2(int n, int ilo, int ihi, double[] a, int _a_offset, int lda, double[] tau, int _tau_offset, double[] work, int _work_offset, intW info) {
        info.val = 0;
        if (n < 0) {
            info.val = -1;
        } else if (ilo < 1 || ilo > Math.max(1, n)) {
            info.val = -2;
        } else if (ihi < Math.min(ilo, n) || ihi > n) {
            info.val = -3;
        } else if (lda < Math.max(1, n)) {
            info.val = -5;
        }
        if (info.val != 0) {
            Xerbla.xerbla("DGEHD2", -info.val);
            return;
        }
        int i = ilo;
        int k = ihi - ilo;
        while (k > 0) {
            Dgehd2.dlarfg_adapter(ihi - i, a, i + (i - 1) * lda + _a_offset, a, Math.min(i + 2, n) - 1 + (i - 1) * lda + _a_offset, 1, tau, i - 1 + _tau_offset);
            double aii = a[i + (i - 1) * lda + _a_offset];
            a[i + (i - 1) * lda + _a_offset] = 1.0;
            Dlarf.dlarf("Right", ihi, ihi - i, a, i + (i - 1) * lda + _a_offset, 1, tau[i - 1 + _tau_offset], a, i * lda + _a_offset, lda, work, _work_offset);
            Dlarf.dlarf("Left", ihi - i, n - i, a, i + (i - 1) * lda + _a_offset, 1, tau[i - 1 + _tau_offset], a, i + i * lda + _a_offset, lda, work, _work_offset);
            a[i + (i - 1) * lda + _a_offset] = aii;
            ++i;
            --k;
        }
    }

    private static void dlarfg_adapter(int i, double[] a, int j, double[] b, int k, int l, double[] c, int m) {
        doubleW dw1 = new doubleW(a[j]);
        doubleW dw2 = new doubleW(c[m]);
        Dlarfg.dlarfg(i, dw1, b, k, l, dw2);
        a[j] = dw1.val;
        c[m] = dw2.val;
    }
}

