/*
 * Decompiled with CFR 0.152.
 */
package rx.testkit;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.observers.TestObserver;
import io.reactivex.schedulers.TestScheduler;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;

public class AssertCompletable
extends AbstractAssert<AssertCompletable, Completable> {
    private final TestObserver subscriber = new TestObserver();
    private TestScheduler scheduler;

    private AssertCompletable(Completable completable) {
        super((Object)completable, AssertCompletable.class);
        completable.subscribe((CompletableObserver)this.subscriber);
    }

    private AssertCompletable(Completable completable, TestScheduler scheduler) {
        super((Object)completable, AssertCompletable.class);
        this.scheduler = scheduler;
        completable.subscribe((CompletableObserver)this.subscriber);
    }

    public static AssertCompletable assertThat(Completable completable) {
        return new AssertCompletable(completable);
    }

    public static AssertCompletable assertThat(Completable completable, TestScheduler scheduler) {
        return new AssertCompletable(completable, scheduler);
    }

    public AssertCompletable after(long duration, TimeUnit timeUnit) {
        if (this.scheduler == null) {
            throw new IllegalStateException("No TestScheduler provided. Perhaps you forgot to 'assertThat(Observable, TestScheduler)'?");
        }
        this.scheduler.advanceTimeBy(duration, timeUnit);
        return this;
    }

    public AssertCompletable hasCompleted() {
        this.subscriber.assertTerminated();
        return this;
    }

    public AssertCompletable hasNotCompleted() {
        this.subscriber.assertNotTerminated();
        return this;
    }

    public AbstractListAssert<?, ? extends List<? extends Throwable>, Throwable> failures() {
        return Assertions.assertThat((List)this.subscriber.errors());
    }
}

