/*
 * Decompiled with CFR 0.152.
 */
package rx.testkit;

import io.reactivex.Single;
import io.reactivex.observers.TestObserver;
import io.reactivex.schedulers.TestScheduler;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class AssertSingle<T>
extends AbstractAssert<AssertSingle<T>, Single<T>> {
    private final TestObserver<T> subscriber = new TestObserver();
    private TestScheduler scheduler;

    private AssertSingle(Single<T> single) {
        super(single, AssertSingle.class);
        single.subscribe(this.subscriber);
    }

    private AssertSingle(Single<T> single, TestScheduler scheduler) {
        super(single, AssertSingle.class);
        this.scheduler = scheduler;
        single.subscribe(this.subscriber);
    }

    public static <T> AssertSingle<T> assertThat(Single<T> single) {
        return new AssertSingle<T>(single);
    }

    public static <T> AssertSingle<T> assertThat(Single<T> single, TestScheduler scheduler) {
        return new AssertSingle<T>(single, scheduler);
    }

    public AbstractObjectAssert<?, ? extends T> value() {
        Object value = this.subscriber.values().get(0);
        return Assertions.assertThat(value);
    }

    public AbstractListAssert<?, ? extends List<? extends Throwable>, Throwable> failures() {
        return Assertions.assertThat((List)this.subscriber.errors());
    }

    public AssertSingle<T> after(long duration, TimeUnit timeUnit) {
        if (this.scheduler == null) {
            throw new IllegalStateException("No TestScheduler provided. Perhaps you forgot to 'assertThat(Observable, TestScheduler)'?");
        }
        this.scheduler.advanceTimeBy(duration, timeUnit);
        return this;
    }

    public AssertSingle<T> hasCompleted() {
        this.subscriber.isTerminated();
        return this;
    }

    public AssertSingle<T> hasNotCompleted() {
        this.subscriber.assertNotTerminated();
        return this;
    }
}

