/*
 * Decompiled with CFR 0.152.
 */
package io.itit.itf.okhttp;

import io.itit.itf.okhttp.PostRequest;
import io.itit.itf.okhttp.RequestCall;
import io.itit.itf.okhttp.callback.Callback;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public abstract class OkHttpRequest {
    protected int id;
    protected String url;
    protected Map<String, String> params;
    protected Map<String, String> headers;
    protected String postBody;
    protected List<PostRequest.FileInfo> fileInfos;
    protected MultipartBody multipartBody;
    protected Request.Builder builder = new Request.Builder();

    protected OkHttpRequest(String url, Object tag, Map<String, String> params, Map<String, String> headers, List<PostRequest.FileInfo> fileInfos, String postBody, MultipartBody multipartBody, int id) {
        this.url = url;
        this.params = params;
        this.headers = headers;
        this.fileInfos = fileInfos;
        this.postBody = postBody;
        this.multipartBody = multipartBody;
        this.id = id;
        if (url == null) {
            throw new IllegalArgumentException("url can not be null.");
        }
        this.builder.url(url).tag(tag);
        this.appendHeaders();
    }

    protected abstract RequestBody buildRequestBody();

    protected abstract Request buildRequest(RequestBody var1);

    public RequestCall build(OkHttpClient okHttpClient) {
        return new RequestCall(this, okHttpClient);
    }

    public Request createRequest(Callback callback) {
        RequestBody requestBody = this.buildRequestBody();
        Request request = this.buildRequest(requestBody);
        return request;
    }

    protected void appendHeaders() {
        Headers.Builder headerBuilder = new Headers.Builder();
        if (this.headers == null || this.headers.isEmpty()) {
            return;
        }
        for (String key : this.headers.keySet()) {
            headerBuilder.add(key, this.headers.get(key));
        }
        this.builder.headers(headerBuilder.build());
    }

    public int getId() {
        return this.id;
    }
}

