/*
 * Decompiled with CFR 0.152.
 */
package io.itit.itf.okhttp;

import io.itit.itf.okhttp.OkHttpRequestBuilder;
import io.itit.itf.okhttp.PostRequest;
import io.itit.itf.okhttp.PutRequest;
import io.itit.itf.okhttp.RequestCall;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;

public class PutBuilder
extends OkHttpRequestBuilder<PutBuilder> {
    private List<PostRequest.FileInfo> fileInfos = new ArrayList<PostRequest.FileInfo>();
    private String body;
    private MultipartBody multipartBody;

    public PutBuilder(OkHttpClient httpClient) {
        super(httpClient);
    }

    @Override
    public RequestCall build() {
        return new PutRequest(this.url, this.tag, this.params, this.headers, this.fileInfos, this.body, this.multipartBody, this.id).build(this.httpClient);
    }

    public PutBuilder body(String body) {
        this.body = body;
        return this;
    }

    public PutBuilder multipartBody(MultipartBody multipartBody) {
        this.multipartBody = multipartBody;
        return this;
    }

    public PutBuilder addFile(String partName, String fileName, byte[] content) {
        PostRequest.FileInfo fileInfo = new PostRequest.FileInfo();
        fileInfo.partName = partName;
        fileInfo.fileName = fileName;
        fileInfo.fileContent = content;
        this.fileInfos.add(fileInfo);
        return this;
    }

    public PutBuilder addFile(String partName, String fileName, File file) {
        PostRequest.FileInfo fileInfo = new PostRequest.FileInfo();
        fileInfo.partName = partName;
        fileInfo.fileName = fileName;
        fileInfo.file = file;
        this.fileInfos.add(fileInfo);
        return this;
    }

    public PutBuilder addFile(String partName, String fileName, String content) throws UnsupportedEncodingException {
        return this.addFile(partName, fileName, content, StandardCharsets.UTF_8.toString());
    }

    public PutBuilder addFile(String partName, String fileName, String content, String charsetName) throws UnsupportedEncodingException {
        return this.addFile(partName, fileName, content.getBytes(charsetName));
    }

    public PutBuilder addFile(String partName, String fileName, byte[] content, String charsetName) throws UnsupportedEncodingException {
        return this.addFile(partName, fileName, content);
    }
}

