/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.column;

import com.github.jasync.sql.db.column.BigDecimalEncoderDecoder;
import com.github.jasync.sql.db.column.ColumnDecoder;
import com.github.jasync.sql.db.column.ColumnDecoderRegistry;
import com.github.jasync.sql.db.column.DateEncoderDecoder;
import com.github.jasync.sql.db.column.DoubleEncoderDecoder;
import com.github.jasync.sql.db.column.FloatEncoderDecoder;
import com.github.jasync.sql.db.column.InetAddressEncoderDecoder;
import com.github.jasync.sql.db.column.IntegerEncoderDecoder;
import com.github.jasync.sql.db.column.LongEncoderDecoder;
import com.github.jasync.sql.db.column.ShortEncoderDecoder;
import com.github.jasync.sql.db.column.StringEncoderDecoder;
import com.github.jasync.sql.db.column.TimeEncoderDecoder;
import com.github.jasync.sql.db.column.TimeWithTimezoneEncoderDecoder;
import com.github.jasync.sql.db.column.UUIDEncoderDecoder;
import com.github.jasync.sql.db.general.ColumnData;
import com.github.jasync.sql.db.postgresql.column.ArrayDecoder;
import com.github.jasync.sql.db.postgresql.column.BooleanEncoderDecoder;
import com.github.jasync.sql.db.postgresql.column.ByteArrayEncoderDecoder;
import com.github.jasync.sql.db.postgresql.column.CharEncoderDecoder;
import com.github.jasync.sql.db.postgresql.column.PostgreSQLColumnDecoderRegistryKt;
import com.github.jasync.sql.db.postgresql.column.PostgreSQLIntervalEncoderDecoder;
import com.github.jasync.sql.db.postgresql.column.PostgreSQLTimestampEncoderDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0014\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0002J\u0016\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/github/jasync/sql/db/postgresql/column/PostgreSQLColumnDecoderRegistry;", "Lcom/github/jasync/sql/db/column/ColumnDecoderRegistry;", "charset", "Ljava/nio/charset/Charset;", "(Ljava/nio/charset/Charset;)V", "bigDecimalArrayDecoder", "Lcom/github/jasync/sql/db/postgresql/column/ArrayDecoder;", "booleanArrayDecoder", "charArrayDecoder", "getCharset", "()Ljava/nio/charset/Charset;", "dateArrayDecoder", "doubleArrayDecoder", "floatArrayDecoder", "inetAddressArrayDecoder", "integerArrayDecoder", "intervalArrayDecoder", "longArrayDecoder", "registry", "", "", "Lcom/github/jasync/sql/db/column/ColumnDecoder;", "shortArrayDecoder", "stringArrayDecoder", "timeArrayDecoder", "timeWithTimestampArrayDecoder", "timestampArrayDecoder", "timestampWithTimezoneArrayDecoder", "uuidArrayDecoder", "decode", "", "kind", "Lcom/github/jasync/sql/db/general/ColumnData;", "value", "Lio/netty/buffer/ByteBuf;", "defaultRegistry", "registerDecoder", "", "type", "decoder", "Companion", "jasync-postgresql"})
public final class PostgreSQLColumnDecoderRegistry
implements ColumnDecoderRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Charset charset;
    @NotNull
    private final ArrayDecoder stringArrayDecoder;
    @NotNull
    private final ArrayDecoder booleanArrayDecoder;
    @NotNull
    private final ArrayDecoder charArrayDecoder;
    @NotNull
    private final ArrayDecoder longArrayDecoder;
    @NotNull
    private final ArrayDecoder shortArrayDecoder;
    @NotNull
    private final ArrayDecoder integerArrayDecoder;
    @NotNull
    private final ArrayDecoder bigDecimalArrayDecoder;
    @NotNull
    private final ArrayDecoder floatArrayDecoder;
    @NotNull
    private final ArrayDecoder doubleArrayDecoder;
    @NotNull
    private final ArrayDecoder timestampArrayDecoder;
    @NotNull
    private final ArrayDecoder timestampWithTimezoneArrayDecoder;
    @NotNull
    private final ArrayDecoder dateArrayDecoder;
    @NotNull
    private final ArrayDecoder timeArrayDecoder;
    @NotNull
    private final ArrayDecoder timeWithTimestampArrayDecoder;
    @NotNull
    private final ArrayDecoder intervalArrayDecoder;
    @NotNull
    private final ArrayDecoder uuidArrayDecoder;
    @NotNull
    private final ArrayDecoder inetAddressArrayDecoder;
    @NotNull
    private final Map<Integer, ColumnDecoder> registry;
    @NotNull
    private static final PostgreSQLColumnDecoderRegistry Instance = new PostgreSQLColumnDecoderRegistry(null, 1, null);

    public PostgreSQLColumnDecoderRegistry(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.charset = charset;
        this.stringArrayDecoder = new ArrayDecoder((ColumnDecoder)StringEncoderDecoder.INSTANCE);
        this.booleanArrayDecoder = new ArrayDecoder((ColumnDecoder)BooleanEncoderDecoder.INSTANCE);
        this.charArrayDecoder = new ArrayDecoder((ColumnDecoder)CharEncoderDecoder.INSTANCE);
        this.longArrayDecoder = new ArrayDecoder((ColumnDecoder)LongEncoderDecoder.INSTANCE);
        this.shortArrayDecoder = new ArrayDecoder((ColumnDecoder)ShortEncoderDecoder.INSTANCE);
        this.integerArrayDecoder = new ArrayDecoder((ColumnDecoder)IntegerEncoderDecoder.INSTANCE);
        this.bigDecimalArrayDecoder = new ArrayDecoder((ColumnDecoder)BigDecimalEncoderDecoder.INSTANCE);
        this.floatArrayDecoder = new ArrayDecoder((ColumnDecoder)FloatEncoderDecoder.INSTANCE);
        this.doubleArrayDecoder = new ArrayDecoder((ColumnDecoder)DoubleEncoderDecoder.INSTANCE);
        this.timestampArrayDecoder = new ArrayDecoder((ColumnDecoder)PostgreSQLTimestampEncoderDecoder.INSTANCE);
        this.timestampWithTimezoneArrayDecoder = new ArrayDecoder((ColumnDecoder)PostgreSQLTimestampEncoderDecoder.INSTANCE);
        this.dateArrayDecoder = new ArrayDecoder((ColumnDecoder)DateEncoderDecoder.INSTANCE);
        this.timeArrayDecoder = new ArrayDecoder((ColumnDecoder)TimeEncoderDecoder.Companion.getInstance());
        this.timeWithTimestampArrayDecoder = new ArrayDecoder((ColumnDecoder)TimeWithTimezoneEncoderDecoder.INSTANCE);
        this.intervalArrayDecoder = new ArrayDecoder((ColumnDecoder)PostgreSQLIntervalEncoderDecoder.INSTANCE);
        this.uuidArrayDecoder = new ArrayDecoder((ColumnDecoder)UUIDEncoderDecoder.INSTANCE);
        this.inetAddressArrayDecoder = new ArrayDecoder((ColumnDecoder)InetAddressEncoderDecoder.INSTANCE);
        this.registry = this.defaultRegistry();
    }

    public /* synthetic */ PostgreSQLColumnDecoderRegistry(Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Charset charset2 = CharsetUtil.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            charset = charset2;
        }
        this(charset);
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    public final void registerDecoder(int type, @NotNull ColumnDecoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        Integer n = type;
        this.registry.put(n, decoder);
        PostgreSQLColumnDecoderRegistryKt.access$getLogger$p().info((Function0)new Function0<Object>(type, decoder){
            final /* synthetic */ int $type;
            final /* synthetic */ ColumnDecoder $decoder;
            {
                this.$type = $type;
                this.$decoder = $decoder;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "register decoder " + this.$type + ' ' + this.$decoder;
            }
        });
    }

    @NotNull
    public Object decode(@NotNull ColumnData kind, @NotNull ByteBuf value, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Object object = this.registry.getOrDefault(kind.dataType(), (ColumnDecoder)StringEncoderDecoder.INSTANCE).decode(kind, value, charset);
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    private final Map<Integer, ColumnDecoder> defaultRegistry() {
        Map res = new LinkedHashMap();
        res.put(16, BooleanEncoderDecoder.INSTANCE);
        res.put(1000, this.booleanArrayDecoder);
        res.put(18, CharEncoderDecoder.INSTANCE);
        res.put(1002, this.charArrayDecoder);
        res.put(20, LongEncoderDecoder.INSTANCE);
        res.put(1016, this.longArrayDecoder);
        res.put(21, ShortEncoderDecoder.INSTANCE);
        res.put(1005, this.shortArrayDecoder);
        res.put(23, IntegerEncoderDecoder.INSTANCE);
        res.put(1007, this.integerArrayDecoder);
        res.put(26, LongEncoderDecoder.INSTANCE);
        res.put(1028, this.longArrayDecoder);
        res.put(1700, BigDecimalEncoderDecoder.INSTANCE);
        res.put(1231, this.bigDecimalArrayDecoder);
        res.put(700, FloatEncoderDecoder.INSTANCE);
        res.put(1021, this.floatArrayDecoder);
        res.put(701, DoubleEncoderDecoder.INSTANCE);
        res.put(1022, this.doubleArrayDecoder);
        res.put(25, StringEncoderDecoder.INSTANCE);
        res.put(1009, this.stringArrayDecoder);
        res.put(1043, StringEncoderDecoder.INSTANCE);
        res.put(1015, this.stringArrayDecoder);
        res.put(1042, StringEncoderDecoder.INSTANCE);
        res.put(1014, this.stringArrayDecoder);
        res.put(1114, PostgreSQLTimestampEncoderDecoder.INSTANCE);
        res.put(1115, this.timestampArrayDecoder);
        res.put(1184, PostgreSQLTimestampEncoderDecoder.INSTANCE);
        res.put(1185, this.timestampWithTimezoneArrayDecoder);
        res.put(1082, DateEncoderDecoder.INSTANCE);
        res.put(1182, this.dateArrayDecoder);
        res.put(1083, TimeEncoderDecoder.Companion.getInstance());
        res.put(1183, this.timeArrayDecoder);
        res.put(1266, TimeWithTimezoneEncoderDecoder.INSTANCE);
        res.put(1270, this.timeWithTimestampArrayDecoder);
        res.put(1186, PostgreSQLIntervalEncoderDecoder.INSTANCE);
        res.put(1187, this.intervalArrayDecoder);
        res.put(791, this.stringArrayDecoder);
        res.put(1003, this.stringArrayDecoder);
        res.put(2950, UUIDEncoderDecoder.INSTANCE);
        res.put(2951, this.uuidArrayDecoder);
        res.put(143, this.stringArrayDecoder);
        res.put(17, ByteArrayEncoderDecoder.INSTANCE);
        res.put(869, InetAddressEncoderDecoder.INSTANCE);
        res.put(1041, this.inetAddressArrayDecoder);
        return res;
    }

    public PostgreSQLColumnDecoderRegistry() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/jasync/sql/db/postgresql/column/PostgreSQLColumnDecoderRegistry$Companion;", "", "()V", "Instance", "Lcom/github/jasync/sql/db/postgresql/column/PostgreSQLColumnDecoderRegistry;", "getInstance", "()Lcom/github/jasync/sql/db/postgresql/column/PostgreSQLColumnDecoderRegistry;", "jasync-postgresql"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PostgreSQLColumnDecoderRegistry getInstance() {
            return Instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

