/*
 * Decompiled with CFR 0.152.
 */
package g1101_1200.s1157_online_majority_element_in_subarray;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MajorityChecker {
    private final Map<Integer, List<Integer>> valToInd = new HashMap<Integer, List<Integer>>();
    private static final int NUM_OF_BITS = 15;
    private final int[][] bitCount;

    public MajorityChecker(int[] arr) {
        this.bitCount = new int[arr.length + 1][15];
        for (int i = 0; i < arr.length; ++i) {
            int val = arr[i];
            List indList = this.valToInd.computeIfAbsent(val, k -> new ArrayList());
            indList.add(i);
            for (int j = 0; j < 15; ++j) {
                this.bitCount[i + 1][j] = this.bitCount[i][j] + (val & 1);
                val >>= 1;
            }
        }
    }

    public int query(int left, int right, int threshold) {
        int indOfRight;
        int candidateVal = 0;
        for (int i = 14; i >= 0; --i) {
            int curBit = this.bitCount[right + 1][i] - this.bitCount[left][i] >= threshold ? 1 : 0;
            candidateVal = (candidateVal << 1) + curBit;
        }
        List<Integer> indList = this.valToInd.get(candidateVal);
        if (indList == null || indList.size() < threshold) {
            return -1;
        }
        int indOfLeft = Collections.binarySearch(indList, left);
        if (indOfLeft < 0) {
            indOfLeft = -indOfLeft - 1;
        }
        if ((indOfRight = Collections.binarySearch(indList, right)) < 0) {
            indOfRight = -indOfRight - 2;
        }
        if (indOfRight - indOfLeft + 1 >= threshold) {
            return candidateVal;
        }
        return -1;
    }
}

