/*
 * Decompiled with CFR 0.152.
 */
package g3401_3500.s3435_frequencies_of_shortest_supersequences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Solution {
    private int m;
    private int forcedMask;
    private int[] adj;
    private char[] idxToChar = new char[26];
    private int[] charToIdx = new int[26];
    private boolean[] used = new boolean[26];

    public List<List<Integer>> supersequences(String[] words) {
        Arrays.fill(this.charToIdx, -1);
        for (String w : words) {
            this.used[w.charAt((int)0) - 97] = true;
            this.used[w.charAt((int)1) - 97] = true;
        }
        for (int c = 0; c < 26; ++c) {
            if (!this.used[c]) continue;
            this.idxToChar[this.m] = (char)(c + 97);
            ++this.m;
        }
        this.adj = new int[this.m];
        for (String w : words) {
            int v;
            int u = this.charToIdx[w.charAt(0) - 97];
            if (u == (v = this.charToIdx[w.charAt(1) - 97])) {
                this.forcedMask |= 1 << u;
                continue;
            }
            int n = u;
            this.adj[n] = this.adj[n] | 1 << v;
        }
        int best = 9999;
        ArrayList<Integer> goodSets = new ArrayList<Integer>();
        for (int s = 0; s < 1 << this.m; ++s) {
            int size;
            if ((s & this.forcedMask) != this.forcedMask || (size = Integer.bitCount(s)) > best || this.hasCycle(s)) continue;
            if (size < best) {
                best = size;
                goodSets.clear();
            }
            goodSets.add(s);
        }
        HashSet<String> seen = new HashSet<String>();
        ArrayList<List<Integer>> ans = new ArrayList<List<Integer>>();
        Iterator iterator = goodSets.iterator();
        while (iterator.hasNext()) {
            int s = (Integer)iterator.next();
            int[] freq = new int[26];
            for (int i = 0; i < this.m; ++i) {
                freq[this.idxToChar[i] - 97] = (s & 1 << i) != 0 ? 2 : 1;
            }
            String key = Arrays.toString(freq);
            if (!seen.add(key)) continue;
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            for (int f : freq) {
                tmp.add(f);
            }
            ans.add(tmp);
        }
        return ans;
    }

    private boolean hasCycle(int mask) {
        int[] color = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            if ((mask >> i & 1) != 0 || color[i] != 0 || !this.dfs(i, color, mask)) continue;
            return true;
        }
        return false;
    }

    private boolean dfs(int u, int[] color, int mask) {
        color[u] = 1;
        for (int nxt = this.adj[u]; nxt != 0; nxt &= nxt - 1) {
            int v = Integer.numberOfTrailingZeros(nxt);
            if ((mask >> v & 1) == 1) continue;
            if (color[v] != 1) continue;
            return true;
        }
        color[u] = 2;
        return false;
    }
}

