/*
 * Decompiled with CFR 0.152.
 */
package g3201_3300.s3283_maximum_number_of_moves_to_kill_all_pawns;

import java.util.LinkedList;

public class Solution {
    private static final int[][] KNIGHT_MOVES = new int[][]{{-2, -1}, {-2, 1}, {-1, -2}, {-1, 2}, {1, -2}, {1, 2}, {2, -1}, {2, 1}};
    private int[][] distances;
    private Integer[][] memo;

    public int maxMoves(int kx, int ky, int[][] positions) {
        int n = positions.length;
        this.distances = new int[n + 1][n + 1];
        this.memo = new Integer[n + 1][1 << n];
        for (int i = 0; i < n; ++i) {
            this.distances[n][i] = this.calculateMoves(kx, ky, positions[i][0], positions[i][1]);
            for (int j = i + 1; j < n; ++j) {
                int dist;
                int n2 = dist = this.calculateMoves(positions[i][0], positions[i][1], positions[j][0], positions[j][1]);
                this.distances[j][i] = n2;
                this.distances[i][j] = n2;
            }
        }
        return this.minimax(n, (1 << n) - 1, true);
    }

    private int minimax(int lastPos, int remainingPawns, boolean isAlice) {
        if (remainingPawns == 0) {
            return 0;
        }
        if (this.memo[lastPos][remainingPawns] != null) {
            return this.memo[lastPos][remainingPawns];
        }
        int result = isAlice ? 0 : Integer.MAX_VALUE;
        for (int i = 0; i < this.distances.length - 1; ++i) {
            if ((remainingPawns & 1 << i) == 0) continue;
            int newRemainingPawns = remainingPawns & ~(1 << i);
            int moveValue = this.distances[lastPos][i] + this.minimax(i, newRemainingPawns, !isAlice);
            result = isAlice ? Math.max(result, moveValue) : Math.min(result, moveValue);
        }
        this.memo[lastPos][remainingPawns] = result;
        return result;
    }

    private int calculateMoves(int x1, int y1, int x2, int y2) {
        if (x1 == x2 && y1 == y2) {
            return 0;
        }
        boolean[][] visited = new boolean[50][50];
        LinkedList<int[]> queue = new LinkedList<int[]>();
        queue.offer(new int[]{x1, y1, 0});
        visited[x1][y1] = true;
        while (!queue.isEmpty()) {
            int[] current = (int[])queue.poll();
            int x = current[0];
            int y = current[1];
            int moves = current[2];
            for (int[] move : KNIGHT_MOVES) {
                int nx = x + move[0];
                int ny = y + move[1];
                if (nx == x2 && ny == y2) {
                    return moves + 1;
                }
                if (nx < 0 || nx >= 50 || ny < 0 || ny >= 50 || visited[nx][ny]) continue;
                queue.offer(new int[]{nx, ny, moves + 1});
                visited[nx][ny] = true;
            }
        }
        return -1;
    }
}

