/*
 * Decompiled with CFR 0.152.
 */
package g3501_3600.s3505_minimum_operations_to_make_elements_within_k_subarrays_equal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;

public class Solution {
    public long minOperations(int[] nums, int x, int k) {
        long[][] dp;
        int i;
        int n = nums.length;
        int windowCount = n - x + 1;
        long[] costs = new long[windowCount];
        SlidingMedian sm = new SlidingMedian();
        for (i = 0; i < x; ++i) {
            sm.add(nums[i]);
        }
        costs[0] = sm.getCost();
        for (i = 1; i < windowCount; ++i) {
            sm.remove(nums[i - 1]);
            sm.add(nums[i + x - 1]);
            costs[i] = sm.getCost();
        }
        for (long[] row : dp = new long[windowCount][k + 1]) {
            Arrays.fill(row, 0x3FFFFFFFFFFFFFFFL);
        }
        dp[0][0] = 0L;
        for (int i2 = 0; i2 < windowCount; ++i2) {
            for (int j = 0; j <= k; ++j) {
                if (i2 > 0) {
                    dp[i2][j] = Math.min(dp[i2][j], dp[i2 - 1][j]);
                }
                if (j > 0 && i2 >= x) {
                    dp[i2][j] = Math.min(dp[i2][j], dp[i2 - x][j - 1] + costs[i2]);
                    continue;
                }
                if (j != 1) continue;
                dp[i2][j] = Math.min(dp[i2][j], costs[i2]);
            }
        }
        return dp[windowCount - 1][k];
    }

    private static class SlidingMedian {
        PriorityQueue<Integer> leftHeap = new PriorityQueue(Collections.reverseOrder());
        PriorityQueue<Integer> rightHeap = new PriorityQueue();
        Map<Integer, Integer> delayedRemovals = new HashMap<Integer, Integer>();
        long sumLeft = 0L;
        long sumRight = 0L;
        int sizeLeft = 0;
        int sizeRight = 0;

        public void add(int num) {
            if (this.leftHeap.isEmpty() || num <= this.leftHeap.peek()) {
                this.leftHeap.offer(num);
                this.sumLeft += (long)num;
                ++this.sizeLeft;
            } else {
                this.rightHeap.offer(num);
                this.sumRight += (long)num;
                ++this.sizeRight;
            }
            this.balanceHeaps();
        }

        public void remove(int num) {
            this.delayedRemovals.put(num, this.delayedRemovals.getOrDefault(num, 0) + 1);
            if (!this.leftHeap.isEmpty() && num <= this.leftHeap.peek()) {
                this.sumLeft -= (long)num;
                --this.sizeLeft;
            } else {
                this.sumRight -= (long)num;
                --this.sizeRight;
            }
            this.balanceHeaps();
            this.pruneHeap(this.leftHeap);
            this.pruneHeap(this.rightHeap);
        }

        private void balanceHeaps() {
            if (this.sizeLeft > this.sizeRight + 1) {
                int num = this.leftHeap.poll();
                this.sumLeft -= (long)num;
                --this.sizeLeft;
                this.rightHeap.offer(num);
                this.sumRight += (long)num;
                ++this.sizeRight;
            } else if (this.sizeRight > this.sizeLeft) {
                int num = this.rightHeap.poll();
                this.sumRight -= (long)num;
                --this.sizeRight;
                this.leftHeap.offer(num);
                this.sumLeft += (long)num;
                ++this.sizeLeft;
            }
        }

        private void pruneHeap(PriorityQueue<Integer> heap) {
            int num;
            while (!heap.isEmpty() && this.delayedRemovals.containsKey(heap.peek()) && this.delayedRemovals.get(num = heap.peek().intValue()) > 0) {
                heap.poll();
                this.delayedRemovals.put(num, this.delayedRemovals.get(num) - 1);
                if (this.delayedRemovals.get(num) != 0) continue;
                this.delayedRemovals.remove(num);
            }
        }

        public int getMedian() {
            return this.leftHeap.peek();
        }

        public long getCost() {
            int median = this.getMedian();
            return (long)median * (long)this.sizeLeft - this.sumLeft + this.sumRight - (long)median * (long)this.sizeRight;
        }
    }
}

