/*
 * Decompiled with CFR 0.152.
 */
package g2001_2100.s2034_stock_price_fluctuation;

import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;

public class StockPrice {
    private Map<Integer, Integer> map = new HashMap<Integer, Integer>();
    private PriorityQueue<Record> maxHeap = new PriorityQueue((r1, r2) -> Integer.compare(r2.price, r1.price));
    private PriorityQueue<Record> minHeap = new PriorityQueue((r1, r2) -> Integer.compare(r1.price, r2.price));
    private int latestTimestamp = 0;

    public void update(int timestamp, int price) {
        this.latestTimestamp = Math.max(timestamp, this.latestTimestamp);
        this.maxHeap.offer(new Record(timestamp, price));
        this.minHeap.offer(new Record(timestamp, price));
        this.map.put(timestamp, price);
    }

    public int current() {
        return this.map.get(this.latestTimestamp);
    }

    public int maximum() {
        while (true) {
            Record rec = this.maxHeap.peek();
            if (this.map.get(rec.time).equals(rec.price)) {
                return rec.price;
            }
            this.maxHeap.poll();
        }
    }

    public int minimum() {
        while (true) {
            Record rec = this.minHeap.peek();
            if (this.map.get(rec.time).equals(rec.price)) {
                return rec.price;
            }
            this.minHeap.poll();
        }
    }

    private static class Record {
        int time;
        int price;

        Record(int time, int price) {
            this.time = time;
            this.price = price;
        }
    }
}

