/*
 * Decompiled with CFR 0.152.
 */
package g3701_3800.s3721_longest_balanced_subarray_ii;

import java.util.HashMap;

public class Solution {
    public int longestBalanced(int[] nums) {
        int n = nums.length;
        HashMap<Integer, Integer> mp = new HashMap<Integer, Integer>();
        Segtree seg = new Segtree(n);
        int ans = 0;
        for (int i = 0; i < n; ++i) {
            int x = nums[i];
            int prev = -1;
            if (mp.containsKey(x)) {
                prev = (Integer)mp.get(x);
            }
            int change = x % 2 == 0 ? -1 : 1;
            seg.update(0, 0, n - 1, prev + 1, i, change);
            int temp = seg.find(0, 0, n - 1, 0, i);
            if (temp != -1) {
                ans = Math.max(ans, i - temp + 1);
            }
            mp.put(x, i);
        }
        return ans;
    }

    private static final class Segtree {
        int[] minsegtree;
        int[] maxsegtree;
        int[] lazysegtree;

        public Segtree(int n) {
            this.minsegtree = new int[4 * n];
            this.maxsegtree = new int[4 * n];
            this.lazysegtree = new int[4 * n];
        }

        private void applyLazy(int ind, int lo, int hi, int val) {
            int n = ind;
            this.minsegtree[n] = this.minsegtree[n] + val;
            int n2 = ind;
            this.maxsegtree[n2] = this.maxsegtree[n2] + val;
            if (lo != hi) {
                int n3 = 2 * ind + 1;
                this.lazysegtree[n3] = this.lazysegtree[n3] + val;
                int n4 = 2 * ind + 2;
                this.lazysegtree[n4] = this.lazysegtree[n4] + val;
            }
            this.lazysegtree[ind] = 0;
        }

        public int find(int ind, int lo, int hi, int l, int r) {
            if (this.lazysegtree[ind] != 0) {
                this.applyLazy(ind, lo, hi, this.lazysegtree[ind]);
            }
            if (hi < l || lo > r) {
                return -1;
            }
            if (this.minsegtree[ind] > 0 || this.maxsegtree[ind] < 0) {
                return -1;
            }
            if (lo == hi) {
                return this.minsegtree[ind] == 0 ? lo : -1;
            }
            int mid = (lo + hi) / 2;
            int ans1 = this.find(2 * ind + 1, lo, mid, l, r);
            if (ans1 != -1) {
                return ans1;
            }
            return this.find(2 * ind + 2, mid + 1, hi, l, r);
        }

        public void update(int ind, int lo, int hi, int l, int r, int val) {
            if (this.lazysegtree[ind] != 0) {
                this.applyLazy(ind, lo, hi, this.lazysegtree[ind]);
            }
            if (hi < l || lo > r) {
                return;
            }
            if (lo >= l && hi <= r) {
                this.applyLazy(ind, lo, hi, val);
                return;
            }
            int mid = (lo + hi) / 2;
            this.update(2 * ind + 1, lo, mid, l, r, val);
            this.update(2 * ind + 2, mid + 1, hi, l, r, val);
            this.minsegtree[ind] = Math.min(this.minsegtree[2 * ind + 1], this.minsegtree[2 * ind + 2]);
            this.maxsegtree[ind] = Math.max(this.maxsegtree[2 * ind + 1], this.maxsegtree[2 * ind + 2]);
        }
    }
}

