/*
 * Decompiled with CFR 0.152.
 */
package g0401_0500.s0432_all_oone_data_structure;

import java.util.HashMap;
import java.util.Map;

public class AllOne {
    private DoubleLinkedList dll = new DoubleLinkedList();
    private Map<String, Node> counter = new HashMap<String, Node>();

    public void inc(String key) {
        Node node = this.counter.get(key);
        if (node == null) {
            node = new Node(key, 1);
            this.counter.put(key, node);
            this.dll.add(node);
        } else {
            ++node.val;
            this.dll.fixOrder(node);
        }
    }

    public void dec(String key) {
        Node node = this.counter.get(key);
        if (node == null) {
            return;
        }
        --node.val;
        if (node.val == 0) {
            this.counter.remove(key);
            this.dll.remove(node);
        } else {
            this.dll.fixOrder(node);
        }
    }

    public String getMaxKey() {
        if (this.dll.tail == null) {
            return "";
        }
        return this.dll.tail.key;
    }

    public String getMinKey() {
        if (this.dll.head == null) {
            return "";
        }
        return this.dll.head.key;
    }

    private static class DoubleLinkedList {
        Node head;
        Node tail;

        DoubleLinkedList() {
        }

        Node fixOrder(Node node) {
            while (node.next != null && node.val > node.next.val) {
                this.swapAdjacentNodes(node, node.next);
            }
            while (node.prev != null && node.val < node.prev.val) {
                this.swapAdjacentNodes(node.prev, node);
            }
            return node;
        }

        void swapAdjacentNodes(Node node1, Node node2) {
            node1.next = node2.next;
            node2.prev = node1.prev;
            if (node1.next != null) {
                node1.next.prev = node1;
            }
            if (node2.prev != null) {
                node2.prev.next = node2;
            }
            node1.prev = node2;
            node2.next = node1;
            if (node1 == this.head) {
                this.head = node2;
            }
            if (node2 == this.tail) {
                this.tail = node1;
            }
        }

        Node add(Node node) {
            node.next = this.head;
            if (this.head != null) {
                this.head.prev = node;
            }
            this.head = node;
            if (this.tail == null) {
                this.tail = this.head;
            }
            return node;
        }

        void remove(Node node) {
            if (node.prev != null) {
                node.prev.next = node.next;
            } else {
                this.head = node.next;
            }
            if (node.next != null) {
                node.next.prev = node.prev;
            } else {
                this.tail = node.prev;
            }
        }
    }

    private static class Node {
        String key;
        int val;
        Node prev;
        Node next;

        Node(String key, int val) {
            this.key = key;
            this.val = val;
        }
    }
}

