/*
 * Decompiled with CFR 0.152.
 */
package g0301_0400.s0399_evaluate_division;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Solution {
    private Map<String, String> root;
    private Map<String, Double> rate;

    public double[] calcEquation(List<List<String>> equations, double[] values, List<List<String>> queries) {
        String y;
        String x;
        this.root = new HashMap<String, String>();
        this.rate = new HashMap<String, Double>();
        int n = equations.size();
        for (List<String> equation : equations) {
            x = equation.get(0);
            y = equation.get(1);
            this.root.put(x, x);
            this.root.put(y, y);
            this.rate.put(x, 1.0);
            this.rate.put(y, 1.0);
        }
        for (int i = 0; i < n; ++i) {
            String x2 = equations.get(i).get(0);
            String y2 = equations.get(i).get(1);
            this.union(x2, y2, values[i]);
        }
        double[] result = new double[queries.size()];
        for (int i = 0; i < queries.size(); ++i) {
            String rootY;
            String rootX;
            x = queries.get(i).get(0);
            y = queries.get(i).get(1);
            result[i] = !this.root.containsKey(x) || !this.root.containsKey(y) ? -1.0 : ((rootX = this.findRoot(x, x, 1.0)).equals(rootY = this.findRoot(y, y, 1.0)) ? this.rate.get(x) / this.rate.get(y) : -1.0);
        }
        return result;
    }

    private void union(String x, String y, double v) {
        String rootX = this.findRoot(x, x, 1.0);
        String rootY = this.findRoot(y, y, 1.0);
        this.root.put(rootX, rootY);
        double r1 = this.rate.get(x);
        double r2 = this.rate.get(y);
        this.rate.put(rootX, v * r2 / r1);
    }

    private String findRoot(String originalX, String x, double r) {
        if (this.root.get(x).equals(x)) {
            this.root.put(originalX, x);
            this.rate.put(originalX, r * this.rate.get(x));
            return x;
        }
        return this.findRoot(originalX, this.root.get(x), r * this.rate.get(x));
    }
}

