/*
 * Decompiled with CFR 0.152.
 */
package g0701_0800.s0715_range_module;

public class RangeModule {
    private final Interval head = new Interval(0, 0);

    public void addRange(int left, int right) {
        Interval pos = this.head;
        while (pos.next != null && pos.next.end < left) {
            pos = pos.next;
        }
        while (pos.next != null && pos.next.start <= right) {
            left = Math.min(pos.next.start, left);
            right = Math.max(pos.next.end, right);
            this.removeNext(pos);
        }
        this.insert(pos, new Interval(left, right));
    }

    public boolean queryRange(int left, int right) {
        Interval pos = this.head;
        while (pos != null) {
            if (left >= pos.start && right <= pos.end) {
                return true;
            }
            pos = pos.next;
        }
        return false;
    }

    public void removeRange(int left, int right) {
        Interval pos = this.head;
        while (pos.next != null && pos.next.end <= left) {
            pos = pos.next;
        }
        Interval prev = pos;
        Interval curr = pos.next;
        while (curr != null && curr.start < right) {
            if (curr.start < left) {
                this.insert(prev, new Interval(curr.start, left));
                curr.start = left;
                prev = prev.next;
                curr = prev.next;
                continue;
            }
            if (right >= curr.end) {
                this.removeNext(prev);
                curr = prev.next;
                continue;
            }
            curr.start = right;
            curr = curr.next;
        }
    }

    private void insert(Interval curr, Interval next) {
        next.next = curr.next;
        curr.next = next;
    }

    private void removeNext(Interval curr) {
        Interval del = curr.next;
        if (del != null) {
            curr.next = del.next;
            del.next = null;
        }
    }

    static class Interval {
        int start;
        int end;
        Interval next;

        public Interval(int l, int r) {
            this.start = l;
            this.end = r;
        }
    }
}

