/*
 * Decompiled with CFR 0.152.
 */
package g0801_0900.s0886_possible_bipartition;

import java.util.ArrayList;
import java.util.List;

public class Solution {
    public boolean possibleBipartition(int n, int[][] dislikes) {
        Graph g = new Graph(n);
        for (int[] dislike : dislikes) {
            g.addEdge(dislike[0] - 1, dislike[1] - 1);
        }
        boolean[] marked = new boolean[n];
        boolean[] colors = new boolean[n];
        for (int v = 0; v < n; ++v) {
            if (marked[v] || this.checkBipartiteDFS(g, marked, colors, v)) continue;
            return false;
        }
        return true;
    }

    private boolean checkBipartiteDFS(Graph g, boolean[] marked, boolean[] colors, int v) {
        marked[v] = true;
        for (int w : g.adj(v)) {
            if (!marked[w]) {
                boolean bl = colors[w] = !colors[v];
                if (this.checkBipartiteDFS(g, marked, colors, w)) continue;
                return false;
            }
            if (colors[v] != colors[w]) continue;
            return false;
        }
        return true;
    }

    private static class Graph {
        private ArrayList<Integer>[] adj;

        public Graph(int v) {
            this.adj = new ArrayList[v];
            for (int i = 0; i < v; ++i) {
                this.adj[i] = new ArrayList();
            }
        }

        private void addEdge(int v, int w) {
            this.adj[v].add(w);
            this.adj[w].add(v);
        }

        private List<Integer> adj(int v) {
            return this.adj[v];
        }
    }
}

