/*
 * Decompiled with CFR 0.152.
 */
package g1101_1200.s1106_parsing_a_boolean_expression;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Solution {
    private String source;
    private int index;

    public boolean parseBoolExpr(String expression) {
        this.source = expression;
        this.index = 0;
        return this.expr();
    }

    private boolean expr() {
        boolean res = false;
        res = this.match('!') ? this.not() : (this.match('&') ? this.and() : (this.match('|') ? this.or() : this.bool()));
        return res;
    }

    private boolean not() {
        this.consume('!', "Expect '!'");
        return this.group().get(0) == false;
    }

    private boolean or() {
        this.consume('|', "Expect '|'");
        boolean res = false;
        for (boolean e : this.group()) {
            res |= e;
        }
        return res;
    }

    private boolean and() {
        this.consume('&', "Expect '&'");
        boolean res = true;
        for (boolean e : this.group()) {
            res &= e;
        }
        return res;
    }

    private List<Boolean> group() {
        this.consume('(', "Expect '('");
        ArrayList<Boolean> res = new ArrayList<Boolean>();
        while (!this.match(')')) {
            res.add(this.expr());
            if (!this.match(',')) continue;
            this.advance();
        }
        this.consume(')', "Expect ')'");
        return res;
    }

    private boolean bool() {
        boolean isTrue = this.match('t');
        this.advance();
        return isTrue;
    }

    private boolean isAtEnd() {
        return this.index >= this.source.length();
    }

    private void advance() {
        if (this.isAtEnd()) {
            return;
        }
        ++this.index;
    }

    private char peek() {
        return this.source.charAt(this.index);
    }

    private boolean match(char ch) {
        if (this.isAtEnd()) {
            return false;
        }
        return this.peek() == ch;
    }

    private void consume(char ch, String message) {
        if (!this.match(ch)) {
            Logger.getLogger(Solution.class.getName()).log(Level.SEVERE, () -> message);
            return;
        }
        this.advance();
    }
}

