/*
 * Decompiled with CFR 0.152.
 */
package g1101_1200.s1175_prime_arrangements;

import java.math.BigInteger;
import java.util.Arrays;

public class Solution {
    private static int mod = 1000000007;

    public int numPrimeArrangements(int n) {
        int numberOfPrimes = this.generatePrimes(n);
        BigInteger x = this.factorial(numberOfPrimes);
        BigInteger y = this.factorial(n - numberOfPrimes);
        return x.multiply(y).mod(BigInteger.valueOf(mod)).intValue();
    }

    private BigInteger factorial(int n) {
        BigInteger fac = BigInteger.ONE;
        for (int i = 2; i <= n; ++i) {
            fac = fac.multiply(BigInteger.valueOf(i));
        }
        return fac.mod(BigInteger.valueOf(mod));
    }

    private int generatePrimes(int n) {
        boolean[] prime = new boolean[n + 1];
        Arrays.fill(prime, 2, n + 1, true);
        int i = 2;
        while (i * i <= n) {
            if (prime[i]) {
                for (int j = i * i; j <= n; j += i) {
                    prime[j] = false;
                }
            }
            ++i;
        }
        int count = 0;
        for (boolean b : prime) {
            if (!b) continue;
            ++count;
        }
        return count;
    }
}

