/*
 * Decompiled with CFR 0.152.
 */
package g2001_2100.s2003_smallest_missing_genetic_value_in_each_subtree;

import java.util.ArrayList;
import java.util.List;

public class Solution {
    public int[] smallestMissingValueSubtree(int[] parents, int[] nums) {
        int i;
        int[] ans = new int[parents.length];
        Node[] all = new Node[parents.length];
        int max = 0;
        for (i = 0; i < nums.length; ++i) {
            all[i] = new Node(i, nums[i]);
            max = Math.max(max, nums[i]);
        }
        for (i = 1; i < parents.length; ++i) {
            all[parents[i]].nodes.add(all[i]);
        }
        this.solve(all[0], ans, new UF(++max, nums));
        return ans;
    }

    private void solve(Node root, int[] ans, UF uf) {
        int max = 1;
        for (Node child : root.nodes) {
            this.solve(child, ans, uf);
            uf.union(root.val, child.val);
            max = Math.max(ans[child.idx], max);
        }
        while (max <= ans.length && uf.isConnected(max, root.val)) {
            ++max;
        }
        ans[root.idx] = max;
    }

    private static class UF {
        int[] rank;
        int[] parent;

        UF(int n, int[] nums) {
            this.rank = new int[n];
            this.parent = new int[n];
            int[] nArray = nums;
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                int m;
                this.parent[m] = m = nArray[i];
            }
        }

        private int find(int x) {
            if (x == this.parent[x]) {
                return x;
            }
            this.parent[x] = this.find(this.parent[x]);
            return this.parent[x];
        }

        private void union(int x, int y) {
            if (this.rank[x = this.find(x)] > this.rank[y = this.find(y)]) {
                this.parent[y] = x;
            } else {
                this.parent[x] = y;
                if (this.rank[x] == this.rank[y]) {
                    int n = y;
                    this.rank[n] = this.rank[n] + 1;
                }
            }
        }

        private boolean isConnected(int x, int y) {
            return this.find(x) == this.find(y);
        }
    }

    private static class Node {
        int idx;
        int val;
        List<Node> nodes;

        Node(int idx, int val) {
            this.idx = idx;
            this.val = val;
            this.nodes = new ArrayList<Node>();
        }
    }
}

