/*
 * Decompiled with CFR 0.152.
 */
package g0301_0400.s0307_range_sum_query_mutable;

public class NumArray {
    private int[] tree;
    private int[] nums;

    public NumArray(int[] nums) {
        this.tree = new int[nums.length + 1];
        this.nums = nums;
        System.arraycopy(nums, 0, this.tree, 1, nums.length);
        for (int i = 1; i < this.tree.length; ++i) {
            int parent = i + (i & -i);
            if (parent >= this.tree.length) continue;
            int n = parent;
            this.tree[n] = this.tree[n] + this.tree[i];
        }
    }

    public void update(int index, int val) {
        int currValue = this.nums[index];
        this.nums[index] = val;
        ++index;
        while (index < this.tree.length) {
            this.tree[index] = this.tree[index] - currValue + val;
            index += index & -index;
        }
    }

    private int sum(int i) {
        int sum = 0;
        while (i > 0) {
            sum += this.tree[i];
            i -= i & -i;
        }
        return sum;
    }

    public int sumRange(int left, int right) {
        return this.sum(right + 1) - this.sum(left);
    }
}

