/*
 * Decompiled with CFR 0.152.
 */
package g3201_3300.s3245_alternating_groups_iii;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Solution {
    private static final int SZ = 63333;
    private static final int OFFSET = 63323;
    private static final BIT[] BITS = new BIT[]{new BIT(), new BIT()};

    private void edt(int x, int y) {
        BITS[1].update(x, x * y);
        BITS[0].update(x, y);
    }

    private int qry(int x) {
        return BITS[1].query(x) + (1 - x) * BITS[0].query(x);
    }

    private int len(int x, int y) {
        return y - x + 1;
    }

    private void removeGroup(int start, int end) {
        this.edt(this.len(start, end), -1);
    }

    private void addGroup(int start, int end) {
        this.edt(this.len(start, end), 1);
    }

    private void initializeGroups(int[] colors, TreeMap<Integer, Integer> groups) {
        int n = colors.length;
        for (int i = 0; i < n; ++i) {
            int r;
            for (r = i; r < n && (colors[r] + colors[i] + r + i) % 2 == 0; ++r) {
            }
            groups.put(i, r - 1);
            this.edt(r - i, 1);
            i = r - 1;
        }
    }

    private int processQueryType1(int[] colors, TreeMap<Integer, Integer> groups, int groupSize) {
        Map.Entry<Integer, Integer> lastGroup;
        int ans = this.qry(groupSize);
        Map.Entry<Integer, Integer> firstGroup = groups.firstEntry();
        if (firstGroup != (lastGroup = groups.lastEntry()) && colors[0] != colors[colors.length - 1]) {
            int leftLen = this.len(firstGroup.getKey(), firstGroup.getValue());
            int rightLen = this.len(lastGroup.getKey(), lastGroup.getValue());
            ans -= Math.max(leftLen - groupSize + 1, 0);
            ans -= Math.max(rightLen - groupSize + 1, 0);
            ans += Math.max(leftLen + rightLen - groupSize + 1, 0);
        }
        return ans;
    }

    private void processQueryType2(int[] colors, TreeMap<Integer, Integer> groups, int x, int newColor) {
        if (colors[x] == newColor) {
            return;
        }
        colors[x] = newColor;
        Map.Entry<Integer, Integer> it = groups.floorEntry(x);
        int l = it.getKey();
        int r = it.getValue();
        this.removeGroup(l, r);
        groups.remove(l);
        int ml = x;
        int mr = x;
        if (l != x) {
            groups.put(l, x - 1);
            this.addGroup(l, x - 1);
        } else if (x > 0 && colors[x] != colors[x - 1] && (it = groups.floorEntry(x - 1)) != null) {
            ml = it.getKey();
            this.removeGroup(it.getKey(), it.getValue());
            groups.remove(it.getKey());
        }
        if (r != x) {
            groups.put(x + 1, r);
            this.addGroup(x + 1, r);
        } else if (x + 1 < colors.length && colors[x + 1] != colors[x] && (it = groups.ceilingEntry(x + 1)) != null) {
            mr = it.getValue();
            this.removeGroup(it.getKey(), it.getValue());
            groups.remove(it.getKey());
        }
        groups.put(ml, mr);
        this.addGroup(ml, mr);
    }

    private void clearAllBITs(int n) {
        for (int i = 0; i <= n + 2; ++i) {
            BITS[0].clear(i);
            BITS[1].clear(i);
        }
    }

    public List<Integer> numberOfAlternatingGroups(int[] colors, int[][] queries) {
        TreeMap<Integer, Integer> groups = new TreeMap<Integer, Integer>();
        int n = colors.length;
        ArrayList<Integer> results = new ArrayList<Integer>();
        this.initializeGroups(colors, groups);
        for (int[] query : queries) {
            if (query[0] == 1) {
                int groupSize = query[1];
                int ans = this.processQueryType1(colors, groups, groupSize);
                results.add(ans);
                continue;
            }
            int index = query[1];
            int newColor = query[2];
            this.processQueryType2(colors, groups, index, newColor);
        }
        this.clearAllBITs(n);
        return results;
    }

    private static class BIT {
        int[] bs = new int[63333];

        private BIT() {
        }

        void update(int x, int y) {
            for (x = 63323 - x; x < 63333; x += x & -x) {
                int n = x;
                this.bs[n] = this.bs[n] + y;
            }
        }

        int query(int x) {
            int ans = 0;
            for (x = 63323 - x; x > 0; x -= x & -x) {
                ans += this.bs[x];
            }
            return ans;
        }

        void clear(int x) {
            for (x = 63323 - x; x < 63333; x += x & -x) {
                this.bs[x] = 0;
            }
        }
    }
}

