/*
 * Decompiled with CFR 0.152.
 */
package g3201_3300.s3242_design_neighbor_sum_service;

public class NeighborSum {
    private final int[][] grid;
    private final int n;
    private final int[] rowIndex;
    private final int[] colIndex;

    public NeighborSum(int[][] grid) {
        this.grid = grid;
        this.n = grid.length;
        this.rowIndex = new int[this.n * this.n];
        this.colIndex = new int[this.n * this.n];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.rowIndex[grid[i][j]] = i;
                this.colIndex[grid[i][j]] = j;
            }
        }
    }

    public int adjacentSum(int value) {
        int sum = 0;
        int i = this.rowIndex[value];
        int j = this.colIndex[value];
        if (i > 0) {
            sum += this.grid[i - 1][j];
        }
        if (i < this.n - 1) {
            sum += this.grid[i + 1][j];
        }
        if (j > 0) {
            sum += this.grid[i][j - 1];
        }
        if (j < this.n - 1) {
            sum += this.grid[i][j + 1];
        }
        return sum;
    }

    public int diagonalSum(int value) {
        int sum = 0;
        int i = this.rowIndex[value];
        int j = this.colIndex[value];
        if (i > 0 && j > 0) {
            sum += this.grid[i - 1][j - 1];
        }
        if (i > 0 && j < this.n - 1) {
            sum += this.grid[i - 1][j + 1];
        }
        if (i < this.n - 1 && j > 0) {
            sum += this.grid[i + 1][j - 1];
        }
        if (i < this.n - 1 && j < this.n - 1) {
            sum += this.grid[i + 1][j + 1];
        }
        return sum;
    }
}

