/*
 * Decompiled with CFR 0.152.
 */
package g3701_3800.s3714_longest_balanced_substring_ii;

import java.util.HashMap;

public class Solution {
    private static final char[] CHARS = new char[]{'a', 'b', 'c'};
    private static final long OFFSET = 100001L;
    private static final long MULTIPLIER = 200003L;

    public int longestBalanced(String s) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        int maxSameChar = this.findLongestSameCharSequence(s);
        int maxTwoChars = this.findLongestTwoCharBalanced(s);
        int maxThreeChars = this.findLongestThreeCharBalanced(s);
        return Math.max(maxSameChar, Math.max(maxTwoChars, maxThreeChars));
    }

    private int findLongestSameCharSequence(String s) {
        int maxLength = 1;
        int currentLength = 1;
        for (int i = 1; i < s.length(); ++i) {
            if (s.charAt(i) == s.charAt(i - 1)) {
                ++currentLength;
                continue;
            }
            maxLength = Math.max(maxLength, currentLength);
            currentLength = 1;
        }
        return Math.max(maxLength, currentLength);
    }

    private int findLongestTwoCharBalanced(String s) {
        int maxLength = 0;
        for (int p = 0; p < CHARS.length; ++p) {
            char firstChar = CHARS[p];
            char secondChar = CHARS[(p + 1) % CHARS.length];
            char excludedChar = CHARS[(p + 2) % CHARS.length];
            maxLength = Math.max(maxLength, this.findBalancedInSegments(s, firstChar, secondChar, excludedChar));
        }
        return maxLength;
    }

    private int findBalancedInSegments(String s, char firstChar, char secondChar, char excludedChar) {
        int maxLength = 0;
        int index = 0;
        while (index < s.length()) {
            if (s.charAt(index) == excludedChar) {
                ++index;
                continue;
            }
            int segmentStart = index;
            while (index < s.length() && s.charAt(index) != excludedChar) {
                ++index;
            }
            int segmentEnd = index;
            if (segmentEnd - segmentStart < 2) continue;
            maxLength = Math.max(maxLength, this.findBalancedInRange(s, segmentStart, segmentEnd, firstChar, secondChar));
        }
        return maxLength;
    }

    private int findBalancedInRange(String s, int start, int end, char firstChar, char secondChar) {
        HashMap<Integer, Integer> differenceMap = new HashMap<Integer, Integer>();
        differenceMap.put(0, 0);
        int difference = 0;
        int maxLength = 0;
        for (int i = start; i < end; ++i) {
            char currentChar = s.charAt(i);
            if (currentChar == firstChar) {
                ++difference;
            } else if (currentChar == secondChar) {
                --difference;
            }
            int position = i - start + 1;
            if (differenceMap.containsKey(difference)) {
                maxLength = Math.max(maxLength, position - (Integer)differenceMap.get(difference));
                continue;
            }
            differenceMap.put(difference, position);
        }
        return maxLength;
    }

    private int findLongestThreeCharBalanced(String s) {
        HashMap<Long, Integer> stateMap = new HashMap<Long, Integer>();
        int diff1 = 0;
        int diff2 = 0;
        stateMap.put(this.encodeState(diff1, diff2), 0);
        int maxLength = 0;
        for (int i = 0; i < s.length(); ++i) {
            char currentChar = s.charAt(i);
            switch (currentChar) {
                case 'a': {
                    ++diff1;
                    ++diff2;
                    break;
                }
                case 'b': {
                    --diff1;
                    break;
                }
                case 'c': {
                    --diff2;
                    break;
                }
            }
            long stateKey = this.encodeState(diff1, diff2);
            if (stateMap.containsKey(stateKey)) {
                maxLength = Math.max(maxLength, i + 1 - (Integer)stateMap.get(stateKey));
                continue;
            }
            stateMap.put(stateKey, i + 1);
        }
        return maxLength;
    }

    private long encodeState(int diff1, int diff2) {
        return ((long)diff1 + 100001L) * 200003L + ((long)diff2 + 100001L);
    }
}

