/*
 * Decompiled with CFR 0.152.
 */
package com.github.sqltojava;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaGenerator {
    private static final Pattern TABLE_HEADER = Pattern.compile("CREATE  TABLE IF NOT EXISTS `mydb`.`(.*?)` \\(");
    private static final Pattern TABLE_FOOTER = Pattern.compile(".*?PRIMARY KEY.*?\\);");
    private static final Pattern TABLE_FOOTER2 = Pattern.compile("^';");
    private static final Pattern COLUMN_WITH_COMMENT = Pattern.compile("  `(\\S*?)` (\\S*?) (NOT\\s{0,1})*NULL (AUTO_INCREMENT )*COMMENT '(.*?)'.*");
    private static final Pattern COLUMN_WITHOUT_COMMENT = Pattern.compile("  `(\\S*?)` (\\S*?) (NOT\\s{0,1})*NULL.*");
    private static final Pattern FOREIGN_KEY = Pattern.compile("    FOREIGN KEY \\(`(\\S*?)` \\).*");
    private static final Pattern TABLE_COMMENT = Pattern.compile("^COMMENT = '$");
    private static final Pattern TABLE_NAME_WITH_HAS = Pattern.compile("^(\\w+?)_has_(\\w+?)$");
    private final String basedir;
    private final List<String> files;
    private final String outPackage;
    private List<String> lines;
    private Map<String, List<String>> tables;
    private Map<String, List<Map<String, String>>> columns;
    private String[] aliases;
    private Logger log;

    public JavaGenerator(String basedir, List<String> files, String outPackage) {
        this.basedir = basedir;
        this.files = files;
        this.outPackage = outPackage;
        this.aliases = new String[0];
    }

    public Logger getLog() {
        if (this.log == null) {
            this.log = Logger.getLogger(JavaGenerator.class.getName());
        }
        return this.log;
    }

    public void generate() {
        this.readLines();
        this.scanTables();
        this.scanColumns();
        this.scanManyToOne();
        this.scanManyToMany();
        this.generateJava();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLines() {
        this.lines = new ArrayList<String>();
        try {
            for (String fileName : this.files) {
                this.getLog().log(Level.INFO, "read file - " + fileName);
                BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
                try {
                    String line = input.readLine();
                    int count = 0;
                    while (line != null) {
                        this.lines.add(line);
                        line = input.readLine();
                        ++count;
                    }
                }
                finally {
                    input.close();
                }
            }
        }
        catch (IOException ex) {
            this.getLog().log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void scanTables() {
        this.tables = new TreeMap<String, List<String>>();
        String tableName = null;
        for (String line : this.lines) {
            Matcher matcher = TABLE_HEADER.matcher(line);
            if (matcher.matches()) {
                tableName = matcher.group(1);
                for (String alias : this.aliases) {
                    if (!tableName.equals(alias.replaceFirst("(.*?):(.*)", "$1"))) continue;
                    tableName = alias.replaceFirst("(.*?):(.*)", "$2");
                }
                this.tables.put(tableName, new ArrayList());
                continue;
            }
            if (TABLE_FOOTER.matcher(line).matches() || TABLE_FOOTER2.matcher(line).matches()) {
                tableName = null;
            }
            if (tableName == null) continue;
            this.tables.get(tableName).add(line);
        }
        this.getLog().log(Level.INFO, "Generate tables: " + this.getKeys(this.tables));
    }

    private void scanColumns() {
        this.columns = new TreeMap<String, List<Map<String, String>>>();
        for (String tableName : this.tables.keySet()) {
            for (String alias : this.aliases) {
                if (!tableName.equals(alias.replaceFirst("(.*?):(.*)", "$1"))) continue;
                tableName = alias.replaceFirst("(.*?):(.*)", "$2");
            }
            this.columns.put(tableName, new ArrayList());
            boolean commentActive = false;
            String commentTable = "";
            for (String line : this.tables.get(tableName)) {
                Matcher foreignKey;
                Matcher lineWithComment = COLUMN_WITH_COMMENT.matcher(line);
                if (lineWithComment.matches()) {
                    TreeMap<String, String> item = new TreeMap<String, String>();
                    item.put("tableName", tableName);
                    item.put("name", lineWithComment.group(1));
                    item.put("type", lineWithComment.group(2));
                    if (((String)item.get("type")).toLowerCase().startsWith("varchar")) {
                        item.put("length", lineWithComment.group(2).replaceFirst(".*?\\((\\d+)\\)", "$1"));
                    }
                    item.put("nullable", Boolean.valueOf(lineWithComment.group(3) == null).toString());
                    String comment = lineWithComment.group(5).replaceFirst("(^.*?)@.*", "$1").trim();
                    if (!"".equals(comment)) {
                        item.put("comment", comment.replaceAll("\\\\n", ""));
                    }
                    int index = 0;
                    boolean sizePresent = false;
                    if (lineWithComment.group(5).contains("@")) {
                        for (String annotItem : lineWithComment.group(5).replaceAll("\\\\n", " ").replaceFirst("^.*?@", "").split(" @")) {
                            item.put("annotation" + index, annotItem.replaceAll("\\\\\"", "\"").replaceAll("\\\\\\\\", "\\\\"));
                            if (!sizePresent) {
                                sizePresent = annotItem.contains("Size");
                            }
                            ++index;
                        }
                    }
                    if (item.get("length") != null && !((String)item.get("length")).isEmpty() && !sizePresent) {
                        item.put("annotation" + index, "Size(max = " + (String)item.get("length") + ")");
                    }
                    this.columns.get(tableName).add(item);
                    continue;
                }
                Matcher lineWithoutComment = COLUMN_WITHOUT_COMMENT.matcher(line);
                if (lineWithoutComment.matches()) {
                    TreeMap<String, String> item = new TreeMap<String, String>();
                    item.put("tableName", tableName);
                    item.put("name", lineWithoutComment.group(1));
                    item.put("type", lineWithoutComment.group(2));
                    if (((String)item.get("type")).toLowerCase().startsWith("varchar")) {
                        item.put("length", lineWithoutComment.group(2).replaceFirst(".*?\\((\\d+)\\)", "$1"));
                    }
                    item.put("nullable", Boolean.valueOf(lineWithoutComment.group(3) == null).toString());
                    this.columns.get(tableName).add(item);
                    if (item.get("length") != null && !((String)item.get("length")).isEmpty()) {
                        item.put("annotation0", "Size(max = " + (String)item.get("length") + ")");
                    }
                }
                if (!tableName.contains("_has_") && (foreignKey = FOREIGN_KEY.matcher(line)).matches()) {
                    for (Map<String, String> item : this.columns.get(tableName)) {
                        if (!item.get("name").equals(foreignKey.group(1))) continue;
                        item.put("name", foreignKey.group(1).replaceFirst("(\\w+)_.*", "$1").toLowerCase());
                        String type = foreignKey.group(1).replaceFirst("(\\w+)_.*", "$1");
                        type = type.substring(0, 1).toUpperCase() + type.substring(1);
                        item.put("type", type);
                        item.put("annotation0", "ManyToOne");
                        item.put("annotation1", "JoinColumn(name=\"" + item.get("name") + "_id\")");
                        item.put("annotation2", "NotNull");
                    }
                }
                if (TABLE_COMMENT.matcher(line).matches()) {
                    commentActive = true;
                    continue;
                }
                if (!commentActive) continue;
                commentTable = commentTable + line + "\n";
            }
            Collections.sort(this.columns.get(tableName), new Comparator<Map<String, String>>(){

                @Override
                public int compare(Map<String, String> o1, Map<String, String> o2) {
                    return o1.get("name").compareTo(o2.get("name"));
                }
            });
            if ("".equals(commentTable)) continue;
            TreeMap<String, String> item = new TreeMap<String, String>();
            item.put("commentTable", commentTable);
            this.columns.get(tableName).add(0, item);
        }
    }

    private void scanManyToOne() {
        for (String tableName : this.tables.keySet()) {
            for (Map<String, String> item : this.columns.get(tableName)) {
                if (!"ManyToOne".equals(item.get("annotation0"))) continue;
                List<Map<String, String>> tableColumns = this.columns.get(item.get("name"));
                TreeMap<String, String> newItem = new TreeMap<String, String>();
                newItem.put("name", tableName + "s");
                newItem.put("type", "List<" + tableName.substring(0, 1).toUpperCase() + tableName.substring(1) + ">");
                newItem.put("annotation0", "OneToMany(mappedBy=\"" + item.get("name") + "\")");
                tableColumns.add(newItem);
            }
        }
    }

    private void scanManyToMany() {
        for (String tableName : this.tables.keySet()) {
            Matcher tableNameWithHas;
            if (tableName.contains("_has_") && (tableNameWithHas = TABLE_NAME_WITH_HAS.matcher(tableName)).matches() && this.fillManyToMany(tableName, tableNameWithHas.group(1), tableNameWithHas.group(2)) && this.fillManyToMany(tableName, tableNameWithHas.group(2), tableNameWithHas.group(1))) continue;
        }
    }

    private boolean fillManyToMany(String tableName, String tableName1, String tableName2) {
        for (String alias : this.aliases) {
            if (tableName1.equals(alias.replaceFirst(".*?_has_(.*?):.*?_has_(.*)", "$2"))) {
                tableName1 = alias.replaceFirst(".*?_has_(.*?):.*?_has_(.*)", "$1");
            }
            if (!tableName2.equals(alias.replaceFirst(".*?_has_(.*?):.*?_has_(.*)", "$2"))) continue;
            tableName2 = alias.replaceFirst(".*?_has_(.*?):.*?_has_(.*)", "$1");
        }
        List<Map<String, String>> items = this.columns.get(tableName1);
        for (Map<String, String> item : items) {
            if (!item.get("name").equals(tableName2 + "s")) continue;
            return false;
        }
        TreeMap<String, String> item = new TreeMap<String, String>();
        item.put("name", tableName2 + "s");
        item.put("type", "List<" + tableName2.substring(0, 1).toUpperCase() + tableName2.substring(1) + ">");
        item.put("annotation0", "ManyToMany(cascade=CascadeType.ALL)");
        item.put("annotation1", "JoinTable(name = \"" + tableName + "\",\n" + "          joinColumns = @JoinColumn(name = \"" + tableName1 + "_id\"),\n" + "          inverseJoinColumns = @JoinColumn(name = \"" + tableName2 + "_id\"))");
        items.add(item);
        return true;
    }

    private void generateJava() {
        Properties p = new Properties();
        p.setProperty("resource.loader", "string");
        p.setProperty("resource.loader.class", "org.apache.velocity.runtime.resource.loader.StringResourceLoader");
        Velocity.init((Properties)p);
        Template template = this.getTemplate("sample.vm");
        for (String tableName : this.tables.keySet()) {
            String className = tableName.substring(0, 1).toUpperCase() + tableName.substring(1).replaceFirst("(^.*?)@.*", "$1");
            VelocityContext context = new VelocityContext();
            context.put("className", (Object)className);
            context.put("tableName", (Object)tableName.replaceFirst("(^.*?)@(.*)", "$2"));
            context.put("columns", this.columns.get(tableName));
            context.put("outPackage", (Object)this.outPackage);
            try {
                String outDirs = this.basedir + "/" + this.outPackage.replaceAll("\\.", "/");
                new File(outDirs).mkdirs();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outDirs + "/" + className + ".java"), "utf-8");
                template.merge((Context)context, (Writer)writer);
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (IOException ex) {
                this.getLog().log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    private Template getTemplate(String templatePath) {
        if (!Velocity.resourceExists((String)templatePath)) {
            StringResourceRepository repo = StringResourceLoader.getRepository();
            repo.putStringResource(templatePath, this.getTemplateFromResource(templatePath));
        }
        return Velocity.getTemplate((String)templatePath);
    }

    private String getTemplateFromResource(String templatePath) {
        try {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(templatePath);
            return IOUtils.toString((InputStream)stream, (String)"UTF-8");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private <T, E> Set<T> getKeys(Map<T, E> map) {
        LinkedHashSet<T> keys = new LinkedHashSet<T>();
        for (Map.Entry<T, E> entry : map.entrySet()) {
            keys.add(entry.getKey());
        }
        return keys;
    }
}

