/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.FieldProcessor;
import com.github.jferard.javamcsv.MetaCSVReadException;

public class BooleanFieldProcessor
implements FieldProcessor<Boolean> {
    private final String trueWord;
    private final String falseWord;
    private final String nullValue;

    public BooleanFieldProcessor(String trueWord, String falseWord, String nullValue) {
        this.trueWord = trueWord;
        this.falseWord = falseWord;
        this.nullValue = nullValue;
    }

    @Override
    public Boolean toObject(String text) throws MetaCSVReadException {
        if (text == null || text.trim().equals(this.nullValue)) {
            return null;
        }
        if ((text = text.trim()).equals(this.trueWord)) {
            return true;
        }
        if (text.equals(this.falseWord)) {
            return false;
        }
        throw new MetaCSVReadException("Unknown boolean: " + text + " (" + this.trueWord + "/" + this.falseWord + ")");
    }

    @Override
    public String toString(Boolean value) {
        if (value == null) {
            return this.nullValue;
        }
        if (value.booleanValue()) {
            return this.trueWord;
        }
        return this.falseWord;
    }
}

