/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.CSVFormatHelper;
import com.github.jferard.javamcsv.CSVRecordProcessor;
import com.github.jferard.javamcsv.MetaCSVData;
import com.github.jferard.javamcsv.MetaCSVReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.csv.CSVFormat;

public class MetaCSVReaderFactory {
    private final MetaCSVData data;
    private final Reader reader;

    public MetaCSVReaderFactory(MetaCSVData data, Reader reader) {
        this.data = data;
        this.reader = reader;
    }

    public MetaCSVReader build() throws IOException {
        CSVFormat format = CSVFormatHelper.getCSVFormat(this.data);
        CSVRecordProcessor processor = this.getProcessor();
        return new MetaCSVReader(format.parse(this.reader), processor, this.data.getMetaData());
    }

    private CSVRecordProcessor getProcessor() {
        return new CSVRecordProcessor(this.data);
    }
}

