/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.DataType;
import com.github.jferard.javamcsv.FieldDescription;
import com.github.jferard.javamcsv.FieldProcessor;
import com.github.jferard.javamcsv.FloatFieldDescription;
import com.github.jferard.javamcsv.PercentageFloatFieldProcessor;
import com.github.jferard.javamcsv.Util;
import java.io.IOException;

public class PercentageFloatFieldDescription
implements FieldDescription<Double> {
    public static final FieldDescription<?> INSTANCE = new PercentageFloatFieldDescription(false, "%", FloatFieldDescription.INSTANCE);
    private final boolean pre;
    private final String symbol;
    private final FieldDescription<Double> numberDescription;

    public PercentageFloatFieldDescription(boolean pre, String symbol, FieldDescription<Double> numberDescription) {
        this.pre = pre;
        this.symbol = symbol;
        this.numberDescription = numberDescription;
    }

    @Override
    public void render(Appendable out) throws IOException {
        Util.render(out, "percentage", this.pre ? "pre" : "post", this.symbol);
        out.append('/');
        this.numberDescription.render(out);
    }

    @Override
    public FieldProcessor<Double> toFieldProcessor(String nullValue) {
        return new PercentageFloatFieldProcessor(this.pre, this.symbol, this.numberDescription.toFieldProcessor(nullValue), nullValue);
    }

    @Override
    public Class<Double> getJavaType() {
        return Double.class;
    }

    @Override
    public DataType getDataType() {
        return DataType.PERCENTAGE_FLOAT;
    }

    public String toString() {
        return String.format("PercentageFieldDescription(%b, %s, %s)", this.pre, this.symbol, this.numberDescription.toString());
    }
}

