/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.FieldProcessor;
import com.github.jferard.javamcsv.MetaCSVReadException;

public class PercentageFloatFieldProcessor
implements FieldProcessor<Double> {
    private final boolean pre;
    private final String symbol;
    private final FieldProcessor<Double> numberProcessor;
    private final String nullValue;

    public PercentageFloatFieldProcessor(boolean pre, String symbol, FieldProcessor<Double> numberProcessor, String nullValue) {
        this.pre = pre;
        this.symbol = symbol;
        this.numberProcessor = numberProcessor;
        this.nullValue = nullValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Double toObject(String text) throws MetaCSVReadException {
        if (text == null || text.equals(this.nullValue)) {
            return null;
        }
        text = text.trim();
        if (this.pre) {
            if (!text.startsWith(this.symbol)) throw new MetaCSVReadException("");
            text = text.substring(this.symbol.length()).trim();
            return this.numberProcessor.toObject(text) / 100.0;
        } else {
            if (!text.endsWith(this.symbol)) throw new MetaCSVReadException("");
            text = text.substring(0, text.length() - this.symbol.length()).trim();
        }
        return this.numberProcessor.toObject(text) / 100.0;
    }

    @Override
    public String toString(Double value) {
        if (value == null) {
            return this.nullValue;
        }
        String valueAsString = this.numberProcessor.toString(value * 100.0);
        if (this.pre) {
            return this.symbol + valueAsString;
        }
        return valueAsString + this.symbol;
    }
}

