/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.CSVParameters;
import org.apache.commons.csv.CSVFormat;

public class CSVFormatHelper {
    public static CSVFormat getCSVFormat(CSVParameters data) {
        boolean doubleQuote;
        CSVFormat format = CSVFormat.DEFAULT;
        char delimiter = data.getDelimiter();
        if (delimiter != format.getDelimiter()) {
            format = format.withDelimiter(delimiter);
        }
        char quoteChar = data.getQuoteChar();
        Character formatQuoteCharacter = format.getQuoteCharacter();
        assert (formatQuoteCharacter != null);
        if (quoteChar == '\u0000') {
            format = format.withQuote(null);
        } else if (quoteChar != formatQuoteCharacter.charValue()) {
            format = format.withQuote(quoteChar);
        }
        String lineTerminator = data.getLineTerminator();
        if (!lineTerminator.equals(format.getRecordSeparator())) {
            format = format.withRecordSeparator(lineTerminator);
        }
        if (doubleQuote = data.isDoubleQuote()) {
            format = format.withEscape(null);
        } else {
            char escapeChar = data.getEscapeChar();
            Character formatEscapeCharacter = format.getEscapeCharacter();
            assert (formatEscapeCharacter == null);
            if (escapeChar != '\u0000' && escapeChar != '\"') {
                format = format.withEscape(escapeChar);
            }
        }
        boolean skipInitialSpace = data.isSkipInitialSpace();
        if (skipInitialSpace != format.getIgnoreSurroundingSpaces()) {
            format = format.withIgnoreSurroundingSpaces(skipInitialSpace);
        }
        return format;
    }
}

