/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.CSVRecordIterator;
import com.github.jferard.javamcsv.MetaCSVCastException;
import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.processor.FieldProcessor;
import com.github.jferard.javamcsv.processor.ProcessorProvider;
import com.github.jferard.javamcsv.processor.ReadFieldProcessor;
import com.github.jferard.javamcsv.processor.ReadProcessorProvider;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.csv.CSVRecord;

public class MetaCSVRecord
implements Iterable<Object> {
    private final int offset;
    private CSVRecord record;
    private ProcessorProvider provider;
    private ReadProcessorProvider readProvider;
    private HashMap<Integer, ReadFieldProcessor<?>> processorByIndex;

    public MetaCSVRecord(CSVRecord record, ProcessorProvider provider, ReadProcessorProvider readProvider, HashMap<Integer, ReadFieldProcessor<?>> processorByIndex, TimeZone timeZone) {
        this.record = record;
        this.provider = provider;
        this.readProvider = readProvider;
        this.processorByIndex = processorByIndex;
        this.offset = Util.UTC_TIME_ZONE.getRawOffset() - timeZone.getRawOffset();
    }

    public Boolean getBoolean(int i) throws MetaCSVCastException, MetaCSVReadException {
        Object value = this.getValue(i);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new MetaCSVCastException("Not a boolean: " + value);
    }

    public Date getDate(int i) throws MetaCSVReadException {
        Object value = this.getValue(i);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            Calendar cal = GregorianCalendar.getInstance(Util.UTC_TIME_ZONE);
            cal.setTimeInMillis(date.getTime() + (long)this.offset);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        throw new MetaCSVCastException("Not a date: " + value);
    }

    public Date getDatetime(int i) throws MetaCSVReadException {
        Object value = this.getValue(i);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return new Date(date.getTime() + (long)this.offset);
        }
        throw new MetaCSVCastException("Not a datetime: " + value);
    }

    public BigDecimal getDecimal(int i) throws MetaCSVReadException {
        Object value = this.getValue(i);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return (BigDecimal)value;
        }
        throw new MetaCSVCastException("Not a number: " + value);
    }

    public Double getFloat(int i) throws MetaCSVReadException {
        Object value = this.getValue(i);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new MetaCSVCastException("Not a number: " + value);
    }

    public Long getInteger(int i) throws MetaCSVReadException {
        Object value = this.getValue(i);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        throw new MetaCSVCastException("Not a number: " + value);
    }

    public CharSequence getText(int i) throws MetaCSVReadException {
        Object value = this.getValue(i);
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return (CharSequence)value;
        }
        throw new MetaCSVCastException("Not a text: " + value);
    }

    public Object getObject(int i) throws MetaCSVReadException {
        return this.getValue(i);
    }

    public int size() {
        return this.record.size();
    }

    private Object getValue(int i) throws MetaCSVReadException {
        FieldProcessor<?> processor = this.provider.getProcessor(i);
        String text = this.record.get(i);
        return processor.toObject(text);
    }

    public List<Object> toList() {
        int size = this.record.size();
        ArrayList<Object> ret = new ArrayList<Object>(size);
        for (int c = 0; c < size; ++c) {
            String text = this.record.get(c);
            ReadFieldProcessor<?> processor = this.readProvider.getProcessor(c);
            ret.add(processor.toObject(text));
        }
        return ret;
    }

    public String toString() {
        return "MetaCSVRecord{record=" + this.record + "}";
    }

    @Override
    public Iterator<Object> iterator() {
        return new CSVRecordIterator(this.record, this.readProvider);
    }
}

