/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.processor;

import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.processor.FieldProcessor;
import java.math.BigDecimal;

public class PercentageDecimalFieldProcessor
implements FieldProcessor<BigDecimal> {
    public static final BigDecimal HUNDRED = BigDecimal.valueOf(100L);
    private final boolean pre;
    private final String symbol;
    private final FieldProcessor<BigDecimal> numberProcessor;
    private final String nullValue;

    public PercentageDecimalFieldProcessor(boolean pre, String symbol, FieldProcessor<BigDecimal> numberProcessor, String nullValue) {
        this.pre = pre;
        this.symbol = symbol;
        this.numberProcessor = numberProcessor;
        this.nullValue = nullValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BigDecimal toObject(String text) throws MetaCSVReadException {
        if (text == null || text.equals(this.nullValue)) {
            return null;
        }
        text = text.trim();
        if (this.pre) {
            if (!text.startsWith(this.symbol)) throw new MetaCSVReadException("Value " + text + " should start with " + this.symbol);
            text = text.substring(this.symbol.length()).trim();
            return this.numberProcessor.toObject(text).divide(HUNDRED);
        } else {
            if (!text.endsWith(this.symbol)) throw new MetaCSVReadException("Value " + text + " should end with " + this.symbol);
            text = text.substring(0, text.length() - this.symbol.length()).trim();
        }
        return this.numberProcessor.toObject(text).divide(HUNDRED);
    }

    @Override
    public String toString(BigDecimal value) {
        if (value == null) {
            return this.nullValue;
        }
        String valueAsString = this.numberProcessor.toString(value.multiply(HUNDRED));
        if (this.pre) {
            return this.symbol + valueAsString;
        }
        return valueAsString + this.symbol;
    }

    @Override
    public BigDecimal cast(Object o) {
        return this.numberProcessor.cast(o);
    }
}

