/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.DataType;
import com.github.jferard.javamcsv.description.FieldDescription;
import com.github.jferard.javamcsv.description.TextFieldDescription;
import java.util.Map;

public class MetaCSVMetaData {
    private final Map<Integer, FieldDescription<?>> descriptionByColIndex;

    public static MetaCSVMetaData create(Map<Integer, FieldDescription<?>> descriptionByColIndex) {
        return new MetaCSVMetaData(descriptionByColIndex);
    }

    public MetaCSVMetaData(Map<Integer, FieldDescription<?>> descriptionByColIndex) {
        this.descriptionByColIndex = descriptionByColIndex;
    }

    public FieldDescription<?> getDescription(int c) {
        FieldDescription<?> ret = this.descriptionByColIndex.get(c);
        if (ret == null) {
            return TextFieldDescription.INSTANCE;
        }
        return ret;
    }

    public <T extends FieldDescription<?>> T getDescription(int c, Class<T> klass) {
        FieldDescription<?> ret = this.descriptionByColIndex.get(c);
        if (ret == null) {
            return (T)TextFieldDescription.INSTANCE;
        }
        return (T)ret;
    }

    public Class<?> getJavaType(int c) {
        FieldDescription<?> ret = this.descriptionByColIndex.get(c);
        if (ret == null) {
            return String.class;
        }
        return ret.getJavaType();
    }

    public DataType getDataType(int c) {
        FieldDescription<?> ret = this.descriptionByColIndex.get(c);
        if (ret == null) {
            return DataType.TEXT;
        }
        return ret.getDataType();
    }
}

