/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.CSVRecordsIterator;
import com.github.jferard.javamcsv.MetaCSVData;
import com.github.jferard.javamcsv.MetaCSVDataException;
import com.github.jferard.javamcsv.MetaCSVMetaData;
import com.github.jferard.javamcsv.MetaCSVParseException;
import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.MetaCSVReaderBuilder;
import com.github.jferard.javamcsv.MetaCSVRecord;
import com.github.jferard.javamcsv.processor.CSVRecordProcessor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.csv.CSVParser;

public class MetaCSVReader
implements Iterable<MetaCSVRecord>,
Closeable {
    private final CSVParser parser;
    private final CSVRecordProcessor processor;
    private MetaCSVMetaData metaData;

    public static MetaCSVReader create(File csvFile) throws IOException, MetaCSVParseException, MetaCSVReadException, MetaCSVDataException {
        return new MetaCSVReaderBuilder().csvFile(csvFile).build();
    }

    public static MetaCSVReader create(File csvFile, File metaCSVFile) throws IOException, MetaCSVParseException, MetaCSVReadException, MetaCSVDataException {
        return new MetaCSVReaderBuilder().csvFile(csvFile).metaCSVFile(metaCSVFile).build();
    }

    public static MetaCSVReader create(File csvFile, String ... metaCSVdirectives) throws IOException, MetaCSVParseException, MetaCSVReadException, MetaCSVDataException {
        return new MetaCSVReaderBuilder().csvFile(csvFile).metaCSVDirectives(metaCSVdirectives).build();
    }

    public static MetaCSVReader create(InputStream csvIn, String ... metaCSVdirectives) throws IOException, MetaCSVParseException, MetaCSVDataException, MetaCSVReadException {
        return new MetaCSVReaderBuilder().csvIn(csvIn).metaCSVDirectives(metaCSVdirectives).build();
    }

    public static MetaCSVReader create(InputStream csvIn, InputStream metaIn) throws IOException, MetaCSVParseException, MetaCSVReadException, MetaCSVDataException {
        return new MetaCSVReaderBuilder().csvIn(csvIn).metaIn(metaIn).build();
    }

    public static MetaCSVReader create(InputStream csvIn, MetaCSVData data) throws IOException, MetaCSVReadException, MetaCSVDataException, MetaCSVParseException {
        return new MetaCSVReaderBuilder().csvIn(csvIn).metaData(data).build();
    }

    public MetaCSVReader(CSVParser parser, CSVRecordProcessor processor, MetaCSVMetaData metaData) {
        this.parser = parser;
        this.processor = processor;
        this.metaData = metaData;
    }

    @Override
    public Iterator<MetaCSVRecord> iterator() {
        return new CSVRecordsIterator(this.parser.iterator(), this.processor);
    }

    public long getRow() {
        return this.parser.getRecordNumber() - 1L;
    }

    public MetaCSVMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
    }
}

