/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.MetaCSVData;
import com.github.jferard.javamcsv.MetaCSVPrinter;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.description.FieldDescription;
import com.github.jferard.javamcsv.description.TextFieldDescription;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MetaCSVRenderer {
    private final MetaCSVPrinter printer;
    private final boolean minimal;

    public static MetaCSVRenderer create(OutputStream os) throws IOException {
        return MetaCSVRenderer.create(os, true);
    }

    public static MetaCSVRenderer create(OutputStream os, boolean minimal) throws IOException {
        OutputStreamWriter outWriter = new OutputStreamWriter(os, Util.UTF_8_CHARSET);
        CSVPrinter printer = new CSVPrinter((Appendable)outWriter, CSVFormat.DEFAULT);
        return MetaCSVRenderer.create(printer, minimal);
    }

    public static MetaCSVRenderer create(final CSVPrinter printer, boolean minimal) {
        return new MetaCSVRenderer(new MetaCSVPrinter(){

            @Override
            public void printRecord(String domain, String key, Object value) throws IOException {
                printer.printRecord(new Object[]{domain, key, value});
            }

            @Override
            public void flush() throws IOException {
                printer.flush();
            }
        }, minimal);
    }

    public MetaCSVRenderer(MetaCSVPrinter printer, boolean minimal) {
        this.printer = printer;
        this.minimal = minimal;
    }

    public void render(MetaCSVData data) throws IOException {
        this.printer.printRecord("domain", "key", "value");
        if (this.minimal) {
            this.renderMinimal(data);
        } else {
            this.renderVerbose(data);
        }
        this.printer.flush();
    }

    private void renderMinimal(MetaCSVData data) throws IOException {
        String nullValue;
        char quoteChar;
        char delimiter;
        String lineTerminator;
        Charset encoding = data.getEncoding();
        if (encoding != Util.UTF_8_CHARSET) {
            this.printer.printRecord("file", "encoding", encoding.toString());
        }
        if (data.isUtf8BOM()) {
            this.printer.printRecord("file", "bom", true);
        }
        if (!(lineTerminator = data.getLineTerminator()).equals("\r\n")) {
            this.printer.printRecord("file", "line_terminator", Util.escapeLineTerminator(lineTerminator));
        }
        if ((delimiter = data.getDelimiter()) != ',') {
            this.printer.printRecord("csv", "delimiter", Character.valueOf(delimiter));
        }
        if (!data.isDoubleQuote()) {
            this.printer.printRecord("csv", "double_quote", "false");
            this.printer.printRecord("csv", "escape_char", Character.valueOf(data.getEscapeChar()));
        }
        if ((quoteChar = data.getQuoteChar()) != '\"') {
            this.printer.printRecord("csv", "quote_char", Character.valueOf(quoteChar));
        }
        if (data.isSkipInitialSpace()) {
            this.printer.printRecord("csv", "skip_initial_space", "true");
        }
        if ((nullValue = data.getNullValue()) != null && !nullValue.isEmpty()) {
            this.printer.printRecord("data", "null_value", nullValue);
        }
        for (int i : data.getSortedColIndices()) {
            FieldDescription<?> description = data.getDescription(i);
            if (description instanceof TextFieldDescription) continue;
            StringBuilder out = new StringBuilder();
            description.render(out);
            this.printer.printRecord("data", "col/" + i + "/type", out.toString());
        }
    }

    private void renderVerbose(MetaCSVData data) throws IOException {
        this.printer.printRecord("file", "encoding", data.getEncoding().toString());
        this.printer.printRecord("file", "bom", data.isUtf8BOM());
        this.printer.printRecord("file", "line_terminator", Util.escapeLineTerminator(data.getLineTerminator()));
        this.printer.printRecord("csv", "delimiter", Character.valueOf(data.getDelimiter()));
        boolean doubleQuote = data.isDoubleQuote();
        this.printer.printRecord("csv", "double_quote", doubleQuote);
        if (!doubleQuote) {
            this.printer.printRecord("csv", "escape_char", Character.valueOf(data.getEscapeChar()));
        }
        this.printer.printRecord("csv", "quote_char", Character.valueOf(data.getQuoteChar()));
        this.printer.printRecord("csv", "skip_initial_space", data.isSkipInitialSpace());
        this.printer.printRecord("data", "null_value", data.getNullValue());
        for (int i : data.getSortedColIndices()) {
            FieldDescription<?> description = data.getDescription(i);
            StringBuilder out = new StringBuilder();
            description.render(out);
            this.printer.printRecord("data", "col/" + i + "/type", out.toString());
        }
    }
}

