/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.description;

import com.github.jferard.javamcsv.DataType;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.description.FieldDescription;
import com.github.jferard.javamcsv.processor.DateFieldProcessor;
import com.github.jferard.javamcsv.processor.FieldProcessor;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateFieldDescription
implements FieldDescription<Date> {
    public static final FieldDescription<?> INSTANCE = DateFieldDescription.create("yyyy-MM-dd");
    private SimpleDateFormat simpleDateFormat;
    private String locale;
    private String nullValue;

    public static FieldDescription<Date> create(String dateFormat) {
        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
        format.setTimeZone(Util.UTC_TIME_ZONE);
        return new DateFieldDescription(format, null);
    }

    public static FieldDescription<Date> create(String dateFormat, String locale) {
        Locale instance = Util.getLocale(locale);
        SimpleDateFormat format = new SimpleDateFormat(dateFormat, instance);
        format.setTimeZone(Util.UTC_TIME_ZONE);
        return new DateFieldDescription(format, locale);
    }

    public DateFieldDescription(SimpleDateFormat simpleDateFormat, String locale) {
        this.simpleDateFormat = simpleDateFormat;
        this.locale = locale;
        this.nullValue = "";
    }

    @Override
    public void render(Appendable out) throws IOException {
        out.append("date/");
        Util.render(out, this.simpleDateFormat.toPattern());
        if (this.locale != null) {
            out.append('/').append(this.locale);
        }
    }

    @Override
    public FieldProcessor<Date> toFieldProcessor(String nullValue) {
        return new DateFieldProcessor(this.simpleDateFormat, this.locale, nullValue, Util.CANONICAL_DATE_FORMAT);
    }

    @Override
    public Class<Date> getJavaType() {
        return Date.class;
    }

    @Override
    public DataType getDataType() {
        return DataType.DATE;
    }

    public String toString() {
        return String.format("DateFieldDescription(%s, %s)", this.simpleDateFormat.toPattern(), this.locale);
    }
}

