/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.description;

import com.github.jferard.javamcsv.DataType;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.description.FieldDescription;
import com.github.jferard.javamcsv.processor.DateFieldProcessor;
import com.github.jferard.javamcsv.processor.FieldProcessor;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DatetimeFieldDescription
implements FieldDescription<Date> {
    public static final FieldDescription<?> INSTANCE = DatetimeFieldDescription.create("yyyy-MM-dd'T'HH:mm:ss");
    private SimpleDateFormat simpleDateFormat;
    private String locale;
    private String nullValue;

    public static FieldDescription<Date> create(String dateFormat) {
        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
        format.setTimeZone(Util.UTC_TIME_ZONE);
        return new DatetimeFieldDescription(format, null);
    }

    public static FieldDescription<Date> create(String dateFormat, String locale) {
        SimpleDateFormat format = new SimpleDateFormat(dateFormat, Util.getLocale(locale));
        format.setTimeZone(Util.UTC_TIME_ZONE);
        return new DatetimeFieldDescription(format, locale);
    }

    public DatetimeFieldDescription(SimpleDateFormat simpleDateFormat, String locale) {
        this.simpleDateFormat = simpleDateFormat;
        this.locale = locale;
        this.nullValue = "";
    }

    @Override
    public void render(Appendable out) throws IOException {
        out.append("datetime/");
        Util.render(out, this.simpleDateFormat.toPattern());
        if (this.locale != null) {
            out.append('/').append(this.locale);
        }
    }

    @Override
    public FieldProcessor<Date> toFieldProcessor(String nullValue) {
        return new DateFieldProcessor(this.simpleDateFormat, this.locale, nullValue, Util.CANONICAL_DATETIME_FORMAT);
    }

    @Override
    public Class<Date> getJavaType() {
        return Date.class;
    }

    @Override
    public DataType getDataType() {
        return DataType.DATETIME;
    }

    public String toString() {
        return String.format("DatetimeDescription(%s, %s)", this.simpleDateFormat.toPattern(), this.locale);
    }
}

