/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.description;

import com.github.jferard.javamcsv.DataType;
import com.github.jferard.javamcsv.description.FieldDescription;
import com.github.jferard.javamcsv.processor.DecimalFieldProcessor;
import com.github.jferard.javamcsv.processor.FieldProcessor;
import java.io.IOException;
import java.math.BigDecimal;

public class DecimalFieldDescription
implements FieldDescription<BigDecimal> {
    public static final FieldDescription<BigDecimal> INSTANCE = new DecimalFieldDescription("", ".");
    private String thousandsSeparator;
    private String decimalSeparator;
    private String nullValue;

    public DecimalFieldDescription(String thousandsSeparator, String decimalSeparator) {
        this.thousandsSeparator = thousandsSeparator;
        this.decimalSeparator = decimalSeparator;
        this.nullValue = "";
    }

    @Override
    public void render(Appendable out) throws IOException {
        if (this.thousandsSeparator.isEmpty()) {
            out.append("decimal//");
        } else {
            out.append("decimal/").append(this.thousandsSeparator).append('/');
        }
        out.append(this.decimalSeparator);
    }

    @Override
    public FieldProcessor<BigDecimal> toFieldProcessor(String nullValue) {
        return new DecimalFieldProcessor(this.thousandsSeparator, this.decimalSeparator, nullValue);
    }

    @Override
    public Class<BigDecimal> getJavaType() {
        return BigDecimal.class;
    }

    @Override
    public DataType getDataType() {
        return DataType.DECIMAL;
    }

    public String toString() {
        return String.format("DecimalFieldDescription(%s, %s)", this.thousandsSeparator, this.decimalSeparator);
    }
}

