/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.description;

import com.github.jferard.javamcsv.DataType;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.description.DecimalFieldDescription;
import com.github.jferard.javamcsv.description.FieldDescription;
import com.github.jferard.javamcsv.processor.FieldProcessor;
import com.github.jferard.javamcsv.processor.PercentageDecimalFieldProcessor;
import java.io.IOException;
import java.math.BigDecimal;

public class PercentageDecimalFieldDescription
implements FieldDescription<BigDecimal> {
    public static final FieldDescription<?> INSTANCE = new PercentageDecimalFieldDescription(false, "%", DecimalFieldDescription.INSTANCE);
    private final boolean pre;
    private final String symbol;
    private final FieldDescription<BigDecimal> numberDescription;

    public PercentageDecimalFieldDescription(boolean pre, String symbol, FieldDescription<BigDecimal> numberDescription) {
        this.pre = pre;
        this.symbol = symbol;
        this.numberDescription = numberDescription;
    }

    @Override
    public void render(Appendable out) throws IOException {
        Util.render(out, "percentage", this.pre ? "pre" : "post", this.symbol);
        out.append('/');
        this.numberDescription.render(out);
    }

    @Override
    public FieldProcessor<BigDecimal> toFieldProcessor(String nullValue) {
        return new PercentageDecimalFieldProcessor(this.pre, this.symbol, this.numberDescription.toFieldProcessor(nullValue), nullValue);
    }

    @Override
    public Class<BigDecimal> getJavaType() {
        return BigDecimal.class;
    }

    @Override
    public DataType getDataType() {
        return DataType.PERCENTAGE_DECIMAL;
    }

    public String toString() {
        return String.format("PercentageFieldDescription(%b, %s, %s)", this.pre, this.symbol, this.numberDescription.toString());
    }
}

