/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.processor;

import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.processor.FieldProcessor;

public class BooleanFieldProcessor
implements FieldProcessor<Boolean> {
    private final String trueWord;
    private final String falseWord;
    private final String nullValue;

    public BooleanFieldProcessor(String trueWord, String falseWord, String nullValue) {
        this.trueWord = trueWord;
        this.falseWord = falseWord;
        this.nullValue = nullValue;
    }

    @Override
    public Boolean toObject(String text) throws MetaCSVReadException {
        if (text == null || text.trim().equals(this.nullValue)) {
            return null;
        }
        if ((text = text.trim()).equalsIgnoreCase(this.trueWord)) {
            return true;
        }
        if (text.equalsIgnoreCase(this.falseWord)) {
            return false;
        }
        throw new MetaCSVReadException("Unknown boolean: " + text + " (" + this.trueWord + "/" + this.falseWord + ")");
    }

    @Override
    public String toString(Boolean value) {
        if (value == null) {
            return this.nullValue;
        }
        if (value.booleanValue()) {
            return this.trueWord;
        }
        return this.falseWord;
    }

    @Override
    public String toCanonicalString(String text) throws MetaCSVReadException {
        if (text == null || text.trim().equals(this.nullValue)) {
            return "";
        }
        if ((text = text.trim()).equalsIgnoreCase(this.trueWord)) {
            return "true";
        }
        if (text.equalsIgnoreCase(this.falseWord)) {
            return "false";
        }
        throw new MetaCSVReadException("Unknown boolean: " + text + " (" + this.trueWord + "/" + this.falseWord + ")");
    }

    @Override
    public Boolean cast(Object o) {
        if (o == null || o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue() != 0L;
        }
        throw new ClassCastException(o.toString());
    }
}

