/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.processor;

import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.processor.FieldProcessor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateFieldProcessor
implements FieldProcessor<Date> {
    private final SimpleDateFormat simpleDateFormat;
    private final String locale;
    private final String nullValue;
    private SimpleDateFormat canonicalFormat;

    public DateFieldProcessor(SimpleDateFormat simpleDateFormat, String locale, String nullValue, SimpleDateFormat canonicalFormat) {
        this.simpleDateFormat = simpleDateFormat;
        this.locale = locale;
        this.nullValue = nullValue;
        this.canonicalFormat = canonicalFormat;
    }

    @Override
    public Date toObject(String text) throws MetaCSVReadException {
        if (text == null || text.equals(this.nullValue)) {
            return null;
        }
        try {
            return this.simpleDateFormat.parse(text);
        }
        catch (ParseException e) {
            throw new MetaCSVReadException(e);
        }
    }

    @Override
    public String toString(Date date) {
        if (date == null) {
            return this.nullValue;
        }
        return this.simpleDateFormat.format(date);
    }

    @Override
    public String toCanonicalString(String text) throws MetaCSVReadException {
        if (text == null || text.equals(this.nullValue)) {
            return "";
        }
        try {
            return this.canonicalFormat.format(this.simpleDateFormat.parse(text));
        }
        catch (ParseException e) {
            throw new MetaCSVReadException(e);
        }
    }

    @Override
    public Date cast(Object o) {
        if (o == null || o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Calendar) {
            return ((Calendar)o).getTime();
        }
        if (o instanceof Number) {
            return new Date(((Number)o).longValue());
        }
        throw new ClassCastException(o.toString());
    }
}

