/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.processor;

import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.processor.FieldProcessor;
import java.math.BigDecimal;

public class DecimalFieldProcessor
implements FieldProcessor<BigDecimal> {
    private final String thousandsSeparator;
    private final String decimalSeparator;
    private final String nullValue;

    public DecimalFieldProcessor(String thousandsSeparator, String decimalSeparator, String nullValue) {
        this.thousandsSeparator = thousandsSeparator;
        this.decimalSeparator = decimalSeparator;
        this.nullValue = nullValue;
    }

    @Override
    public BigDecimal toObject(String text) throws MetaCSVReadException {
        if (text == null || text.equals(this.nullValue)) {
            return null;
        }
        try {
            return Util.parseBigDecimal(text, this.thousandsSeparator, this.decimalSeparator);
        }
        catch (NumberFormatException e) {
            throw new MetaCSVReadException(e);
        }
    }

    @Override
    public String toString(BigDecimal bd) {
        if (bd == null) {
            return this.nullValue;
        }
        return Util.formatBigDecimal(bd, this.thousandsSeparator, this.decimalSeparator);
    }

    @Override
    public String toCanonicalString(String text) throws MetaCSVReadException {
        if (text == null || text.equals(this.nullValue)) {
            return "";
        }
        return Util.normalizeDecimalText(text, this.thousandsSeparator, this.decimalSeparator);
    }

    @Override
    public BigDecimal cast(Object o) {
        if (o == null || o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        Number n = (Number)o;
        return new BigDecimal(n.toString());
    }
}

