/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.processor;

import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.OnError;
import com.github.jferard.javamcsv.ReadError;
import com.github.jferard.javamcsv.description.FieldDescription;
import com.github.jferard.javamcsv.processor.FieldProcessor;
import com.github.jferard.javamcsv.processor.ReadFieldProcessor;
import com.github.jferard.javamcsv.processor.WriteFieldProcessor;
import java.io.IOException;

public class FieldProcessorFactory {
    public <T> ReadFieldProcessor<T> toReadFieldProcessor(FieldDescription<T> description, String nullValue, OnError onError) {
        final FieldProcessor<T> rawProcessor = description.toFieldProcessor(nullValue);
        switch (onError) {
            case WRAP: {
                final String strDescription = this.getColTypeValue(description);
                return new ReadFieldProcessor<T>(){

                    @Override
                    public Object toObject(String text) {
                        try {
                            return rawProcessor.toObject(text);
                        }
                        catch (MetaCSVReadException e) {
                            return new ReadError(text, strDescription);
                        }
                    }

                    @Override
                    public String toCanonicalString(String text) {
                        try {
                            return rawProcessor.toCanonicalString(text);
                        }
                        catch (MetaCSVReadException e) {
                            return new ReadError(text, strDescription).toString();
                        }
                    }
                };
            }
            case NULL: {
                return new ReadFieldProcessor<T>(){

                    @Override
                    public T toObject(String text) {
                        try {
                            return rawProcessor.toObject(text);
                        }
                        catch (MetaCSVReadException e) {
                            return null;
                        }
                    }

                    @Override
                    public String toCanonicalString(String text) {
                        try {
                            return rawProcessor.toCanonicalString(text);
                        }
                        catch (MetaCSVReadException e) {
                            return "";
                        }
                    }
                };
            }
            case TEXT: {
                return new ReadFieldProcessor<T>(){

                    @Override
                    public Object toObject(String text) {
                        try {
                            return rawProcessor.toObject(text);
                        }
                        catch (MetaCSVReadException e) {
                            return text;
                        }
                    }

                    @Override
                    public String toCanonicalString(String text) {
                        try {
                            return rawProcessor.toCanonicalString(text);
                        }
                        catch (MetaCSVReadException e) {
                            return text;
                        }
                    }
                };
            }
        }
        return new ReadFieldProcessor<T>(){

            @Override
            public Object toObject(String text) {
                try {
                    return rawProcessor.toObject(text);
                }
                catch (MetaCSVReadException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public String toCanonicalString(String text) {
                try {
                    return rawProcessor.toCanonicalString(text);
                }
                catch (MetaCSVReadException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    <T> String getColTypeValue(FieldDescription<T> description) {
        try {
            StringBuilder sb = new StringBuilder();
            description.render(sb);
            return sb.toString();
        }
        catch (IOException e) {
            return "???";
        }
    }

    public <T> WriteFieldProcessor toWriteFieldProcessor(FieldDescription<T> description, final String nullValue, OnError onError, boolean lenient) {
        final FieldProcessor<T> rawProcessor = description.toFieldProcessor(nullValue);
        if (lenient) {
            switch (onError) {
                case WRAP: {
                    throw new RuntimeException("OnError.WRAP not allowed for write error.");
                }
                case NULL: {
                    return new WriteFieldProcessor(){

                        @Override
                        public String toString(Object o) {
                            try {
                                Object text = rawProcessor.cast(o);
                                return rawProcessor.toString(text);
                            }
                            catch (ClassCastException e) {
                                return nullValue;
                            }
                        }
                    };
                }
                case TEXT: {
                    return new WriteFieldProcessor(){

                        @Override
                        public String toString(Object o) {
                            try {
                                Object value = rawProcessor.cast(o);
                                return rawProcessor.toString(value);
                            }
                            catch (ClassCastException e) {
                                return o.toString();
                            }
                        }
                    };
                }
            }
            return new WriteFieldProcessor(){

                @Override
                public String toString(Object o) {
                    Object value = rawProcessor.cast(o);
                    return rawProcessor.toString(value);
                }
            };
        }
        switch (onError) {
            case WRAP: {
                throw new RuntimeException("OnError.WRAP not allowed for write error.");
            }
            case NULL: {
                return new WriteFieldProcessor(){

                    @Override
                    public String toString(Object o) {
                        try {
                            Object value = o;
                            return rawProcessor.toString(value);
                        }
                        catch (ClassCastException e) {
                            return nullValue;
                        }
                    }
                };
            }
            case TEXT: {
                return new WriteFieldProcessor(){

                    @Override
                    public String toString(Object o) {
                        try {
                            Object value = o;
                            return rawProcessor.toString(value);
                        }
                        catch (ClassCastException e) {
                            return o.toString();
                        }
                    }
                };
            }
        }
        return new WriteFieldProcessor(){

            @Override
            public String toString(Object o) {
                Object value = o;
                return rawProcessor.toString(value);
            }
        };
    }
}

