/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.processor;

import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.processor.FieldProcessor;

public class FloatFieldProcessor
implements FieldProcessor<Double> {
    private final String thousandsSeparator;
    private final String decimalSeparator;
    private final String nullValue;

    public FloatFieldProcessor(String thousandsSeparator, String decimalSeparator, String nullValue) {
        this.thousandsSeparator = thousandsSeparator;
        this.decimalSeparator = decimalSeparator;
        this.nullValue = nullValue;
    }

    @Override
    public Double toObject(String text) throws MetaCSVReadException {
        if (text == null || text.equals(this.nullValue)) {
            return null;
        }
        try {
            return Util.parseDouble(text, this.thousandsSeparator, this.decimalSeparator);
        }
        catch (NumberFormatException e) {
            throw new MetaCSVReadException(e);
        }
    }

    @Override
    public String toString(Double d) {
        if (d == null) {
            return this.nullValue;
        }
        return Util.formatDouble(d, this.thousandsSeparator, this.decimalSeparator);
    }

    @Override
    public String toCanonicalString(String text) throws MetaCSVReadException {
        if (text == null || text.equals(this.nullValue)) {
            return "";
        }
        return Util.normalizeDecimalText(text, this.thousandsSeparator, this.decimalSeparator);
    }

    @Override
    public Double cast(Object o) {
        if (o == null || o instanceof Double) {
            return (Double)o;
        }
        return ((Number)o).doubleValue();
    }
}

