/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmatsu.multipreference;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.jmatsu.multipreference.DataStore;
import java.io.File;
import java.util.Map;
import java.util.Set;

final class SharedPreferencesDataStore
implements DataStore {
    @NonNull
    private final Context context;
    @NonNull
    private final String name;
    @NonNull
    private final SharedPreferences sharedPreferences;
    @Nullable
    private SharedPreferences.Editor temporaryEditorForTransaction;
    private boolean isDestroyed;

    SharedPreferencesDataStore(@NonNull Context context, @NonNull String name) {
        this.context = context.getApplicationContext();
        this.name = name;
        this.sharedPreferences = context.getSharedPreferences(name, 0);
    }

    @Override
    @NonNull
    public Map<String, ?> getAll() {
        return this.sharedPreferences.getAll();
    }

    @Override
    public boolean contains(@NonNull String key) {
        return this.sharedPreferences.contains(key);
    }

    @Override
    @Nullable
    public String getNullableString(@NonNull String key, @Nullable String defaultValue2) {
        return this.sharedPreferences.getString(key, defaultValue2);
    }

    @Override
    @NonNull
    public String getNonNullString(@NonNull String key, @NonNull String defaultValue2) {
        return this.sharedPreferences.getString(key, defaultValue2);
    }

    @Override
    @Nullable
    public Set<String> getNullableStringSet(@NonNull String key, @Nullable Set<String> defaultValue2) {
        return this.sharedPreferences.getStringSet(key, defaultValue2);
    }

    @Override
    @NonNull
    public Set<String> getNonNullStringSet(@NonNull String key, @NonNull Set<String> defaultValue2) {
        return this.sharedPreferences.getStringSet(key, defaultValue2);
    }

    @Override
    public int getInt(@NonNull String key, int defaultValue2) {
        return this.sharedPreferences.getInt(key, defaultValue2);
    }

    @Override
    public long getLong(@NonNull String key, long defaultValue2) {
        return this.sharedPreferences.getLong(key, defaultValue2);
    }

    @Override
    public float getFloat(@NonNull String key, float defaultValue2) {
        return this.sharedPreferences.getFloat(key, defaultValue2);
    }

    @Override
    public boolean getBoolean(@NonNull String key, boolean defaultValue2) {
        return this.sharedPreferences.getBoolean(key, defaultValue2);
    }

    @Override
    public void setNullableString(@NonNull String key, @Nullable String value) {
        this.getEditorToBeUpdated().putString(key, value).apply();
    }

    @Override
    public void setNonNullString(@NonNull String key, @NonNull String value) {
        this.getEditorToBeUpdated().putString(key, value).apply();
    }

    @Override
    public void setNullableStringSet(@NonNull String key, @Nullable Set<String> value) {
        this.getEditorToBeUpdated().putStringSet(key, value).apply();
    }

    @Override
    public void setNonNullStringSet(@NonNull String key, @NonNull Set<String> value) {
        this.getEditorToBeUpdated().putStringSet(key, value).apply();
    }

    @Override
    public void setInt(@NonNull String key, int value) {
        this.getEditorToBeUpdated().putInt(key, value).apply();
    }

    @Override
    public void setLong(@NonNull String key, long value) {
        this.getEditorToBeUpdated().putLong(key, value).apply();
    }

    @Override
    public void setFloat(@NonNull String key, float value) {
        this.getEditorToBeUpdated().putFloat(key, value).apply();
    }

    @Override
    public void setBoolean(@NonNull String key, boolean value) {
        this.getEditorToBeUpdated().putBoolean(key, value).apply();
    }

    @Override
    @SuppressLint(value={"CommitPrefEdits"})
    public void beginTransaction() {
        this.checkNotDestroyed();
        if (this.isInTransaction()) {
            throw new RuntimeException("Multiple transactions are not allowed.");
        }
        this.temporaryEditorForTransaction = this.sharedPreferences.edit();
    }

    @Override
    public synchronized boolean finishTransaction(boolean commit) {
        boolean succeeded;
        this.checkNotDestroyed();
        if (!this.isInTransaction()) {
            return false;
        }
        if (this.temporaryEditorForTransaction == null) {
            return false;
        }
        if (commit) {
            succeeded = this.temporaryEditorForTransaction.commit();
        } else {
            this.temporaryEditorForTransaction.apply();
            succeeded = true;
        }
        this.temporaryEditorForTransaction = null;
        return succeeded;
    }

    @Override
    public synchronized void cancelTransaction() {
        this.checkNotDestroyed();
        if (!this.isInTransaction()) {
            return;
        }
        this.temporaryEditorForTransaction = null;
    }

    @Override
    public boolean isInTransaction() {
        return this.temporaryEditorForTransaction != null;
    }

    @Override
    public void clear() {
        if (this.isDestroyed) {
            return;
        }
        SharedPreferences.Editor editor = this.temporaryEditorForTransaction != null ? this.temporaryEditorForTransaction : this.sharedPreferences.edit();
        editor.clear().apply();
        this.temporaryEditorForTransaction = null;
    }

    @Override
    public void destroySelf() {
        if (this.isDestroyed) {
            return;
        }
        if (SharedPreferencesDataStore.deleteSharedPreferences(this.context, this.name)) {
            this.isDestroyed = true;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    @NonNull
    private SharedPreferences.Editor getEditorToBeUpdated() {
        this.checkNotDestroyed();
        return this.temporaryEditorForTransaction != null ? this.temporaryEditorForTransaction : this.sharedPreferences.edit();
    }

    private void checkNotDestroyed() {
        if (this.isDestroyed) {
            throw new RuntimeException("This operation is not allowed after destroy.");
        }
    }

    @Nullable
    private static File getSharedPreferencesFile(@NonNull Context context, @NonNull String name) {
        File file = SharedPreferencesDataStore.getDataDir(context);
        if (file == null) {
            return null;
        }
        return new File(file, "/shared_prefs/" + name);
    }

    private static boolean deleteSharedPreferences(@NonNull Context context, @NonNull String name) {
        File file = SharedPreferencesDataStore.getSharedPreferencesFile(context, name);
        return file == null || !file.exists() || file.delete();
    }

    @Nullable
    private static File getDataDir(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            return context.getDataDir();
        }
        String dataDir = context.getApplicationInfo().dataDir;
        return dataDir != null ? new File(dataDir) : null;
    }
}

