/*
 * Decompiled with CFR 0.152.
 */
package com.github.johnnyjayjay.discord.commandapi;

import com.github.johnnyjayjay.discord.commandapi.CommandSettings;
import com.github.johnnyjayjay.discord.commandapi.ICommand;
import java.util.Arrays;
import java.util.List;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.events.message.guild.GuildMessageReceivedEvent;

public class CommandEvent
extends GuildMessageReceivedEvent {
    private final Command command;

    public CommandEvent(JDA api, long responseNumber, Message message, Command command) {
        super(api, responseNumber, message);
        this.command = command;
    }

    public Command getCommand() {
        return this.command;
    }

    public static class Command {
        private ICommand command;
        private String label;
        private String[] args;

        Command(String raw, String prefix, CommandSettings settings) {
            String[] argsWithoutPrefix = raw.replaceFirst(prefix, "").split(" ");
            String commandLabel = settings.labelIgnoreCase() ? argsWithoutPrefix[0].toLowerCase() : argsWithoutPrefix[0];
            List<String> argList = Arrays.asList(argsWithoutPrefix);
            String[] args = argList.subList(1, argList.size()).toArray(new String[argList.size() - 1]);
            this.args = args;
            this.label = commandLabel;
            if (settings.getCommands().containsKey(commandLabel)) {
                this.command = settings.getCommands().get(commandLabel);
            }
        }

        public String getLabel() {
            return this.label;
        }

        public String[] getArgs() {
            return this.args;
        }

        public ICommand getExecutor() {
            return this.command;
        }
    }
}

