/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanhds.sqlbuilder;

import com.github.jonathanhds.sqlbuilder.Database;
import com.github.jonathanhds.sqlbuilder.select.RowMapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Context {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final Connection connection;
    private final StringBuilder sql;
    private final List<Object> parameters;
    private final Database database;
    private final transient Logger log = Logger.getLogger(this.getClass().getName());

    public Context(Context clone) {
        this.connection = clone.connection;
        this.parameters = new LinkedList<Object>(clone.parameters);
        this.sql = new StringBuilder();
        this.database = clone.database;
    }

    public Context(Database database, Connection connection) {
        this.connection = connection;
        this.database = database;
        this.sql = new StringBuilder();
        this.parameters = new LinkedList<Object>();
    }

    public String toString() {
        return this.sql.toString();
    }

    public <E> List<E> list(RowMapper<E> rowMapper) throws SQLException {
        LinkedList<E> result = new LinkedList<E>();
        try (ResultSet resultSet = this.execute(this.toString());){
            int rowNum = 0;
            while (resultSet.next()) {
                E obj = rowMapper.convert(resultSet, rowNum++);
                result.add(obj);
            }
        }
        return result;
    }

    public <E> E single(RowMapper<E> rowMapper) throws SQLException {
        E result = null;
        try (ResultSet resultSet = this.execute(this.toString());){
            if (resultSet.next()) {
                result = rowMapper.convert(resultSet, 1);
                if (resultSet.next()) {
                    throw new SQLException("The query returned more than one result");
                }
            }
        }
        return result;
    }

    public Context append(String expression) {
        this.sql.append(expression);
        return this;
    }

    public Context appendLine(String expression) {
        this.sql.append(expression);
        this.sql.append(NEW_LINE);
        return this;
    }

    public Context newLine() {
        this.sql.append(NEW_LINE);
        return this;
    }

    public void addParameters(Object ... parameters) {
        for (Object parameter : parameters) {
            this.parameters.add(parameter);
        }
    }

    public Database getDatabase() {
        return this.database;
    }

    private ResultSet execute(String sql) throws SQLException {
        this.log.log(Level.INFO, "\n" + sql);
        try (PreparedStatement statement = this.prepareStatement(sql);){
            ResultSet resultSet = statement.executeQuery();
            return resultSet;
        }
    }

    private PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(sql);
        int i = 1;
        for (Object parameter : this.parameters) {
            statement.setObject(i++, parameter);
        }
        return statement;
    }
}

