/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanhds.sqlbuilder.builder;

import com.github.jonathanhds.sqlbuilder.Context;
import com.github.jonathanhds.sqlbuilder.Database;
import com.github.jonathanhds.sqlbuilder.delete.Delete;
import com.github.jonathanhds.sqlbuilder.insert.Insert;
import com.github.jonathanhds.sqlbuilder.select.Select;
import com.github.jonathanhds.sqlbuilder.update.Update;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class QueryBuilder {
    private final Context context;

    public QueryBuilder(Database database, DataSource dataSource) throws SQLException {
        this(database, dataSource.getConnection());
    }

    public QueryBuilder(Database database, Connection connection) {
        this.context = new Context(database, connection);
    }

    public Select select() {
        return new Select(this.context);
    }

    public Update update() {
        return new Update(this.context);
    }

    public Update update(String table) {
        return new Update(this.context, table);
    }

    public Delete delete() {
        return new Delete(this.context);
    }

    public Delete delete(String table) {
        return new Delete(this.context, table);
    }

    public Insert insert() {
        return new Insert(this.context);
    }

    public Insert insert(String table) {
        return new Insert(this.context, table);
    }

    public String toString() {
        return this.context.toString();
    }
}

